<?php

class ITSEC_Settings_Page_Sidebar_Widget_Malware_Scan extends ITSEC_Settings_Page_Sidebar_Widget {
	private $script_version = 2;


	public function __construct() {
		ITSEC_Lib::load( 'feature-flags' );

		$this->id       = 'malware-scan';
		$this->title    = ITSEC_Lib_Feature_Flags::is_enabled( 'site_scanner' ) ? __( 'Site Scan', 'better-wp-security' ) : __( 'Malware Scan', 'better-wp-security' );
		$this->priority = 8;

		parent::__construct();
	}

	public function enqueue_scripts_and_styles() {
		$vars = array(
			'clickedButtonText' => __( 'Scanning...', 'better-wp-security' ),
			'showDetailsText'   => __( 'Show Details', 'better-wp-security' ),
			'hideDetailsText'   => __( 'Hide Details', 'better-wp-security' ),
		);

		wp_enqueue_script( 'itsec-settings-malware-scan-settings-script', plugins_url( 'js/settings-page.js', __FILE__ ), array( 'jquery' ), $this->script_version, true );
		wp_localize_script( 'itsec-settings-malware-scan-settings-script', 'itsecMalwareScanData', $vars );

		wp_enqueue_style( 'itsec-settings-malware-scan-style', plugins_url( 'css/settings.css', __FILE__ ), array(), $this->script_version );
		wp_enqueue_style( 'itsec-core-packages-components-site-scan-results-style' );
	}

	public function handle_ajax_request( $data ) {
		require_once( dirname( __FILE__ ) . '/class-itsec-malware-scanner.php' );
		require_once( dirname( __FILE__ ) . '/class-itsec-malware-scan-results-template.php' );

		$temporary_error = false;

		if ( ! ITSEC_Core::current_user_can_manage() ) {
			$results = new WP_Error( 'itsec-settings-malware-scan-insufficient-privileges', __( 'An error prevented the scan from completing as expected. The currently logged in user does not have sufficient permissions to run this scan. You may need to log out of the site and log back in.', 'better-wp-security' ) );
		} else {
			$results         = ITSEC_Malware_Scanner::scan();
			$temporary_error = ITSEC_Malware_Scanner::is_sucuri_error( $results );
		}

		if ( $temporary_error ) {
			ITSEC_Response::add_warning( __( 'Malware scanning is temporarily unavailable, please try again later.', 'better-wp-security' ) );
		} else {
			ITSEC_Response::set_response( ITSEC_Malware_Scan_Results_Template::get_html( $results, true ) );
		}
	}

	public function render( $form ) {
		if ( ITSEC_Lib_Feature_Flags::is_enabled( 'site_scanner' ) ) {
			$button      = __( 'Scan Now', 'better-wp-security' );
			$module      = 'site-scanner';
			$description = __( 'This %1$ssite scan is powered by iThemes%2$s. We use several datapoints to check for known malware, blacklisting status, website errors and out-of-date software. These datapoints are not 100% accurate, but we try our best to provide thorough results.', 'better-wp-security' );
			$description = sprintf( $description, '<a href="https://help.ithemes.com/hc/en-us/articles/360046334433" target="_blank">', '</a>' );
		} else {
			$button      = __( 'Scan Homepage for Malware', 'better-wp-security' );
			$module      = 'malware';
			$description = sprintf( __( 'This malware scan is powered by <a href="%s">Sucuri SiteCheck</a>. It checks for known malware, blacklisting status, website errors and out-of-date software. Although the Sucuri team does its best to provide thorough results, 100%% accuracy is not realistic and is not guaranteed.', 'better-wp-security' ), esc_url( 'https://ithemes.com/sitecheck' ) );
		}

		?>
		<div class="hide-if-no-js">
			<p><?php echo $description; ?></p>
			<p><?php printf( __( 'Results of previous scans can be found on the <a href="%s">logs page</a>.', 'better-wp-security' ), ITSEC_Core::get_logs_page_url( $module ) ); ?></p>
			<div class='itsec-malware-scan-results-wrapper'></div>
			<?php $form->add_button( 'start', array( 'value' => $button, 'class' => 'button-primary' ) ); ?>
		</div>
		<div class="hide-if-js">
			<p><?php _e( 'The malware scanner requires Javascript in order to function. If Javascript is disabled in your browser, please enable it. If Javascript is not disabled, a script from another plugin, the theme, or a broken WordPress file is preventing the malware scanner\'s script from executing properly. Please try disabling other plugins to see if that resolves the issue.', 'better-wp-security' ); ?></p>
		</div>
		<?php
	}

	protected function save( $data ) {
	}
}

new ITSEC_Settings_Page_Sidebar_Widget_Malware_Scan();
