<?php
/*
Plugin Name: GreenStory for WooCommerce 
Plugin URI: https://greenstory.ca/
Description: Plugin for injecting greenstory widget. 
Author: greenstory
Version: 1.1.0
Author URI: https://greenstory.ca/
*/

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

// Load Scripts
require_once(plugin_dir_path(__FILE__) . '/includes/gs-plugin.scripts.php');
require_once(plugin_dir_path(__FILE__) . '/includes/gs-plugin.class.php');

$settings_page = new Greenstory_AdminPage();
//============product page ===================//
$product_data = get_option('gs-product');
$product_widget_hook = $product_data['product_hook_value'];
add_action($product_widget_hook, 'greenstory_product_widget', 1);
function greenstory_product_widget()
{
    $product_data = get_option('gs-product');
    $general_data = get_option('gs-general');

    if ($general_data['global-widget-id'] == "No"  ||  trim($general_data['general-client-id']) == "") {
        return false;
    }

    global $product;
    $id = $product->get_id();
    if (trim($general_data['general-client-id']) != "" && isset($product_data['product_checkbox']) && $product_data['product_checkbox'] != 0) {
        echo '<gs-product lang="' . ($general_data['lang-widget-id'] ?  $general_data['lang-widget-id'] : get_bloginfo("language")) . '" locale="' . ($general_data['locale-widget-id'] ? $general_data['locale-widget-id'] :  get_locale()) . '" widgetType="product" productID="' . $id . '" clientID="' . trim($general_data['general-client-id']) . '"></gs-product>';
    }
}
//===============cart widget=========================//
$cart_data = get_option('gs-cart');
$cart_widget_hook = $cart_data['cart_hook_value'];
add_action($cart_widget_hook, 'greenstory_cart_widget', 1);

function greenstory_cart_widget()
{
    $general_data = get_option('gs-general');
    if ($general_data['global-widget-id'] == "No"  ||  trim($general_data['general-client-id']) == "") {
        return false;
    }
    $cart_data = get_option('gs-cart');
    if (WC()->cart->get_cart_contents_count() > 0 && isset($cart_data['cart_checkbox']) && $cart_data['cart_checkbox'] != 0) {
        $order_details = array();
        foreach (WC()->cart->get_cart() as $cart_item) {
            $id = (string) $cart_item['data']->get_id();
            $quantity = (string) $cart_item['quantity'];
            $product = array('id' => $id, 'quantity' => $quantity);
            array_push($order_details, $product);
        }
        $order_details = json_encode($order_details);
        echo '<gs-cart lang="' . ($general_data['lang-widget-id'] ?  $general_data['lang-widget-id'] : get_bloginfo("language")) . '" locale="' . ($general_data['locale-widget-id'] ? $general_data['locale-widget-id'] :  get_locale()) . '" widgetType="cart" productList=' . $order_details . ' clientID="' . trim($general_data['general-client-id']) . '"></gs-cart> ';
    }
}

//===============cart pffset widget=========================//
$cart_offset_data = get_option('gs-cart-offset');
$cart_offest_widget_hook = $cart_offset_data['cart_offset_hook_value'];

add_action($cart_offest_widget_hook, 'greenstory_cart_offset_widget', 1);

function greenstory_cart_offset_widget()
{
    $general_data = get_option('gs-general');

    if ($general_data['global-widget-id'] == "No"  ||  trim($general_data['general-client-id']) == "") {
        return false;
    }
    $cart_offset_data = get_option('gs-cart-offset');

    if (WC()->cart->get_cart_contents_count() > 0 && isset($cart_offset_data['cart_offset_checkbox']) && $cart_offset_data['cart_offset_checkbox'] != 0) {
        $order_details = array();
        foreach (WC()->cart->get_cart() as $cart_item) {
            $id = (string) $cart_item['data']->get_id();
            $quantity = (string) $cart_item['quantity'];
            $product = array('id' => $id, 'quantity' => $quantity);
            array_push($order_details, $product);
        }
        $order_details = json_encode($order_details);
        echo '<gs-cart-offset lang="' . ($general_data['lang-widget-id'] ?  $general_data['lang-widget-id'] : get_bloginfo("language")) . '" locale="' . ($general_data['locale-widget-id'] ? $general_data['locale-widget-id'] :  get_locale()) . '" widgetType="cart" productList=' . $order_details . ' clientID="' . trim($general_data['general-client-id']) . '"></gs-cart-offset> ';
    }
}

//====================counter widget=======================//
$counter_data = get_option('gs-counter');
$counter_widget_hook = $counter_data['counter-hook'];
add_action($counter_widget_hook, 'greenstory_counter_widget', 1);
function greenstory_counter_widget()
{
    $general_data = get_option('gs-general');

    if ($general_data['global-widget-id'] == "No"  ||  trim($general_data['general-client-id']) == "") {
        return false;
    }

    $counter_data = get_option('gs-counter');
    if (isset($counter_data['counter_checkbox']) && $counter_data['counter_checkbox'] != 0) {
        $counter_data = get_option('gs-counter');
        echo '<gs-counter lang="' . ($general_data['lang-widget-id'] ?  $general_data['lang-widget-id'] : get_bloginfo("language")) . '" locale="' . ($general_data['locale-widget-id'] ? $general_data['locale-widget-id'] :  get_locale()) . '" widgettype="counter" clientID="' . trim($general_data['general-client-id']) . '" ></gs-counter>';
    }
}

//====================brand offset widget=======================//
$brand_offset_data = get_option('gs-brand-offset');
$brand_offset_widget_hook = $brand_offset_data['brand_offset_hook_value'];
add_action($brand_offset_widget_hook, 'greenstory_brand_offset_widget', 1);
function greenstory_brand_offset_widget()
{
    $general_data = get_option('gs-general');

    if ($general_data['global-widget-id'] == "No"  ||  trim($general_data['general-client-id']) == "") {
        return false;
    }

    $brand_offset_data = get_option('gs-brand-offset');
    if (isset($brand_offset_data['brand_offset_checkbox']) && $brand_offset_data['brand_offset_checkbox'] != 0) {
        $brand_offset_data = get_option('gs-brand-offset');
        echo '<gs-brand-offset lang="' . ($general_data['lang-widget-id'] ?  $general_data['lang-widget-id'] : get_bloginfo("language")) . '" locale="' . ($general_data['locale-widget-id'] ? $general_data['locale-widget-id'] :  get_locale()) . '" clientID="' . trim($general_data['general-client-id']) . '"></gs-brand-offset>';
    }
}

//====================customer  impact widget=======================//
$customer_imapact_data = get_option('gs-customer-impact');
$customer_imapact_widget_hook = $customer_imapact_data['customer_impact_hook_value'];
add_action($customer_imapact_widget_hook, 'greenstory_customer_impact_widget', 1);
function greenstory_customer_impact_widget()
{
    $general_data = get_option('gs-general');

    if ($general_data['global-widget-id'] == "No"  ||  trim($general_data['general-client-id']) == "") {
        return false;
    }

    $customer_imapact_data = get_option('gs-customer-impact');



    if (isset($customer_imapact_data['customer_impact_checkbox']) && $customer_imapact_data['customer_impact_checkbox'] != 0) {
        echo '<gs-customer lang="' . ($general_data['lang-widget-id'] ?  $general_data['lang-widget-id'] : get_bloginfo("language")) . '" locale="' . ($general_data['locale-widget-id'] ? $general_data['locale-widget-id'] :  get_locale()) . '" clientid="' . trim($general_data['general-client-id']) . '" customerid="' . get_current_user_id() . '"></gs-customer>';
    }
}


//====================pdp offset widget=======================//
$pdp_offset_data = get_option('gs-pdp-offset');
$customer_pdp_offset_hook = $pdp_offset_data['pdp_offset_hook_value'];
add_action($customer_pdp_offset_hook, 'greenstory_pdp_offset_widget', 1);
function greenstory_pdp_offset_widget()
{
    $general_data = get_option('gs-general');

    if ($general_data['global-widget-id'] == "No"  ||  trim($general_data['general-client-id']) == "") {
        return false;
    }
    global $product;
    $id = $product->get_id();
    $pdp_offset_data = get_option('gs-pdp-offset');
    if (isset($pdp_offset_data['pdp_offset_checkbox']) && $pdp_offset_data['pdp_offset_checkbox'] != 0) {
        echo '<gs-offset lang="' . ($general_data['lang-widget-id'] ?  $general_data['lang-widget-id'] : get_bloginfo("language")) . '" locale="' . ($general_data['locale-widget-id'] ? $general_data['locale-widget-id'] :  get_locale()) . '" productId="' . $id . '" clientID="' . trim($general_data['general-client-id']) . '"></gs-offset>';
    }
}
