<?php
require_once(plugin_dir_path(__FILE__) . '/helper/request.php');
require_once(plugin_dir_path(__FILE__) . '/helper/order.php');
require_once(plugin_dir_path(__FILE__) . '/helper/product.php');

function greenstory_scripts()
{
    wp_enqueue_script('jquery');
    wp_enqueue_script('export-ajax-script', plugins_url('/export.js', __FILE__), array('jquery'), '1.0', true);

    $nonce = wp_create_nonce('zz_ajax_nonce');
    wp_localize_script('export-ajax-script', 'zz_ajax_var', array('ajax_url' => admin_url('admin-ajax.php'), 'nonce' => $nonce));
}
add_action('admin_enqueue_scripts', 'greenstory_scripts');

add_action('wp_ajax_export', 'export');
add_action('wp_ajax_nopriv_export', 'export');

function export()
{
    syncAllProduct();
    wp_die();
}

add_action('woocommerce_before_save_order_items', 'push_order_greenstory', 10, 2);
add_action('woocommerce_checkout_order_processed', 'push_order_greenstory', 10, 2);
function push_order_greenstory($order_id, $items = null)
{
    $general_data = get_option('gs-general');

    if (!$general_data["general-order-enable"] || ($general_data["general-order-enable"] && $general_data["general-order-enable"] == "No")) {
        log_info("---Order push not enabled---");
        return false;
    }
    try {
        $requestBody = prepareOrderRequestBody($order_id);
        //print_r(json_encode($requestBody));
        makeRequest("POST", trim($general_data['general-order-url']), json_encode($requestBody));
    } catch (Exception $e) {
        log_info("Push order failed");
        log_info($e->getMessage());
    }
}

add_action('woocommerce_update_product', 'push_product_greenstory', 10, 4);
function push_product_greenstory($id)
{
    $general_data = get_option('gs-general');

    if (!$general_data["general-product-enable"] || ($general_data["general-product-enable"] && $general_data["general-product-enable"] == "No")) {
        log_info("---Product push not enabled---");
        return false;
    }
    try {
        $requestBody = prepareProductRequestBody($id);
        //print_r(json_encode($requestBody));
        makeRequest("POST", trim($general_data['general-product-url']), json_encode($requestBody));
    } catch (Exception $e) {
        log_info("Push product failed");
        log_info($e->getMessage());
    }
}

function log_info($msg)
{
    $file = plugin_dir_path(__FILE__) . '/info.txt';

    $open = fopen($file, "a");
    $write = fputs($open, $msg . "\n");
    fclose($open);
}

function getSelectOptions($source, $dataStore, $id)
{
    $html = '<select name="gs-general[' . $id . ']" id="' . $id . '">';
    foreach ($source as $value) {
        $html .= '<option  value="' . $value['value'] . '" ' . ($dataStore[$id] == $value['value'] ? "selected" : "") . ' >' . $value['label'] . '</option>';
    }
    $html .= '</select>';
    return $html;
}

function getLanguage()
{
    return [
        ['value' => '', 'label' => __('Default')],
        ['value' => 'en', 'label' => __('English')],
        ['value' => 'fr', 'label' => __('French')],
        ['value' => 'nl', 'label' => __('Dutch; Flemish')],
        ['value' => 'de', 'label' => __('German')],
        ['value' => 'es', 'label' => __('Spanish; Castilian')],
        ['value' => 'pt', 'label' => __('Portuguese')],
        ['value' => 'ja', 'label' => __('Japanese')],
        ['value' => 'zh', 'label' => __('Chinese')],
        ['value' => 'sv', 'label' => __('Swedish')],
        ['value' => 'it', 'label' => __('Italian')],
        ['value' => 'tr', 'label' => __('Turkish')],
        ['value' => 'zh-hans', 'label' => __('Simplified - Chinese')],
        ['value' => 'hu', 'label' => __('Hungarian')],
        ['value' => 'da', 'label' => __('Danish')],
    ];
}

function getLocale()
{
    return [
        ['value' => '', 'label' => __('Default')],
        ['value' => 'pt', 'label' => __('Portuguese (Portugal)')],
        ['value' => 'nl', 'label' => __('Dutch')],
        ['value' => 'nb', 'label' => __('Norwegian (Bokmål) ')],
        ['value' => 'ja', 'label' => __('Japanese')],
        ['value' => 'hu', 'label' => __('Hungarian')],
        ['value' => 'fr', 'label' => __('French (France)')],
        ['value' => 'es', 'label' => __('Spanish (Spain)')],
        ['value' => 'en', 'label' => __('English')],
        ['value' => 'de', 'label' => __('German')],
        ['value' => 'da', 'label' => __('Danish')]
    ];;
}

function getYesNo()
{
    return [
        ['value' => 'Yes', 'label' => __('Yes')],
        ['value' => 'No', 'label' => __('No')]
    ];;
}


class Greenstory_AdminPage
{

    public $product_data;
    public $general_data;
    public $cart_data;
    public $counter_data;
    public $cart_offset_data;
    public $customer_impact_data;
    public $pdp_offset_data;
    public $brand_offset_data;
    public function __construct()
    {
        add_action('admin_menu', array($this, 'greenstory_plugin_page'));
        add_action('admin_init', array($this, 'greenstory_options_init'));
    }

    public function greenstory_plugin_page()
    {
        add_menu_page('GreenStory', 'GreenStory', 'manage_options', 'greenstory', array($this, 'greenstory_admin_tabs'), plugin_dir_url(__FILE__) . '/gs-logo.png)');
    }

    //function for tab view and ui view contents
    public function greenstory_admin_tabs()
    {
        $this->product_data = get_option('gs-product');
        $this->general_data = get_option('gs-general');


        $this->cart_data = get_option('gs-cart');
        $this->cart_offset_data = get_option('gs-cart-offset');
        $this->customer_impact_data = get_option('gs-customer-impact');
        $this->pdp_offset_data = get_option('gs-pdp-offset');
        $this->brand_offset_data = get_option('gs-brand-offset');
        $this->counter_data = get_option('gs-counter');

        $cart_screen = (isset($_GET['action']) && 'cart' == $_GET['action']) ? true : false;
        $cart_offset_screen = (isset($_GET['action']) && 'cart-offset' == $_GET['action']) ? true : false;
        $customer_impact_screen = (isset($_GET['action']) && 'customer-impact' == $_GET['action']) ? true : false;
        $pdp_offset_screen = (isset($_GET['action']) && 'pdp-offset' == $_GET['action']) ? true : false;
        $brand_offset_screen = (isset($_GET['action']) && 'brand-offset' == $_GET['action']) ? true : false;
        $general_screen = (!isset($_GET['action']) || (isset($_GET['action']) && $_GET['action'] == "general")) ? true : false;


        $product_screen = (isset($_GET['action']) && 'product' == $_GET['action']) ? true : false;

        $counter_screen = (isset($_GET['action']) && 'counter' == $_GET['action']) ? true : false;    ?>
        <div class="wrap">
            <h1>GreenStory for WooCommerce</h1>

            <h2 class="nav-tab-wrapper">
                <a href="<?php echo esc_url(add_query_arg(array('action' => 'general'), admin_url('admin.php?page=greenstory'))); ?>" class="nav-tab<?php if (!isset($_GET['action']) || isset($_GET['action']) && 'cart' != $_GET['action'] && 'product' != $_GET['action'] && 'cart-offset' != $_GET['action']  && 'pdp-offset' != $_GET['action'] && 'brand-offset' != $_GET['action'] && 'customer-impact' != $_GET['action']   &&  'counter' != $_GET['action']) echo ' nav-tab-active'; ?>"><?php esc_html_e('General'); ?></a>
                <a href="<?php echo esc_url(add_query_arg(array('action' => 'product'), admin_url('admin.php?page=greenstory'))); ?>" class="nav-tab<?php if ($product_screen) echo ' nav-tab-active'; ?>"><?php esc_html_e('Product widget'); ?></a>
                <a href="<?php echo esc_url(add_query_arg(array('action' => 'cart'), admin_url('admin.php?page=greenstory'))); ?>" class="nav-tab<?php if ($cart_screen) echo ' nav-tab-active'; ?>"><?php esc_html_e('Cart widget'); ?></a>
                <a href="<?php echo esc_url(add_query_arg(array('action' => 'cart-offset'), admin_url('admin.php?page=greenstory'))); ?>" class="nav-tab<?php if ($cart_offset_screen) echo ' nav-tab-active'; ?>"><?php esc_html_e('Cart offset widget'); ?></a>
                <a href="<?php echo esc_url(add_query_arg(array('action' => 'customer-impact'), admin_url('admin.php?page=greenstory'))); ?>" class="nav-tab<?php if ($customer_impact_screen) echo ' nav-tab-active'; ?>"><?php esc_html_e('Customer impact widget'); ?></a>
                <a href="<?php echo esc_url(add_query_arg(array('action' => 'pdp-offset'), admin_url('admin.php?page=greenstory'))); ?>" class="nav-tab<?php if ($pdp_offset_screen) echo ' nav-tab-active'; ?>"><?php esc_html_e('PDP offset widget'); ?></a>
                <a href="<?php echo esc_url(add_query_arg(array('action' => 'brand-offset'), admin_url('admin.php?page=greenstory'))); ?>" class="nav-tab<?php if ($brand_offset_screen) echo ' nav-tab-active'; ?>"><?php esc_html_e('Brand offset widget'); ?></a>
                <a href="<?php echo esc_url(add_query_arg(array('action' => 'counter'), admin_url('admin.php?page=greenstory'))); ?>" class="nav-tab<?php if ($counter_screen) echo ' nav-tab-active'; ?>"><?php esc_html_e('Counter widget'); ?></a>
            </h2>

            <form method="post" action="options.php"><?php //   settings_fields( 'gs-product' );
                                                        if ($cart_screen) {
                                                            settings_fields('gs-cart');
                                                            do_settings_sections('gs-settings-cart');
                                                            submit_button();
                                                        } elseif ($counter_screen) {
                                                            settings_fields('gs-counter');
                                                            do_settings_sections('gs-settings-counter');
                                                            submit_button();
                                                        } elseif ($cart_offset_screen) {
                                                            settings_fields('gs-cart-offset');
                                                            do_settings_sections('gs-settings-cart-offset');
                                                            submit_button();
                                                        } else if ($general_screen) {
                                                            settings_fields('gs-general');
                                                            do_settings_sections('gs-settings-general');
                                                            submit_button();
                                                        } else if ($pdp_offset_screen) {
                                                            settings_fields('gs-pdp-offset');
                                                            do_settings_sections('gs-settings-pdp-offset');
                                                            submit_button();
                                                        } else if ($customer_impact_screen) {
                                                            settings_fields('gs-customer-impact');
                                                            do_settings_sections('gs-settings-customer-impact');
                                                            submit_button();
                                                        } else if ($brand_offset_screen) {
                                                            settings_fields('gs-brand-offset');
                                                            do_settings_sections('gs-settings-brand-offset');
                                                            submit_button();
                                                        } else if ($product_screen) {
                                                            settings_fields('gs-product');
                                                            do_settings_sections('gs-settings-product');
                                                            submit_button();
                                                        } else {
                                                            settings_fields('gs-product');
                                                            do_settings_sections('gs-settings-product');
                                                            submit_button();
                                                        } ?>
            </form>
        </div> <?php
            }

            public function greenstory_options_init()
            { //initiate the plugin



                //general

                register_setting(
                    'gs-general', // Option group
                    'gs-general', // Option name
                    array($this, 'greenstory_sanitize') // Sanitize
                );



                add_settings_section(
                    'setting_general_id', // ID
                    'General Settings', // Title
                    array($this, 'greenstory_section_info'), // Callback
                    'gs-settings-general' // Page
                );

                add_settings_field( //plugin fields
                    'general-client-id',
                    'Green Story Client ID',
                    array($this, 'greenstory_general_client_id'),
                    'gs-settings-general',
                    'setting_general_id'
                );

                add_settings_field( //plugin fields
                    'general-library-id',
                    'Green Story Library File',
                    array($this, 'greenstory_general_library_id'),
                    'gs-settings-general',
                    'setting_general_id'
                );

                // add_settings_field( //plugin fields
                //     'general-site-id',
                //     'Site ID',
                //     array($this, 'greenstory_general_site_id'),
                //     'gs-settings-general',
                //     'setting_general_id'
                // );

                add_settings_field( //plugin fields
                    'general-site-domain',
                    'Site Domain	',
                    array($this, 'greenstory_general_site_domain'),
                    'gs-settings-general',
                    'setting_general_id'
                );

                add_settings_field( //plugin fields
                    'general-enc-key',
                    'Encryption Key',
                    array($this, 'greenstory_general_enc_key'),
                    'gs-settings-general',
                    'setting_general_id'
                );

                add_settings_section(
                    'notification_general_id', // ID
                    'Notifications', // Title
                    array($this, 'greenstory_section_info'), // Callback
                    'gs-settings-general' // Page
                );



                //notification

                add_settings_field( //plugin fields
                    'general-product-url',
                    'Product Notification Url',
                    array($this, 'greenstory_generaly_product_url'),
                    'gs-settings-general',
                    'notification_general_id'
                );

                // add_settings_field( //plugin fields
                //     'general-interval-days',
                //     'Set interval in days',
                //     array($this, 'greenstory_general_interval_days'),
                //     'gs-settings-general',
                //     'notification_general_id'
                // );

                add_settings_field( //plugin fields
                    'general-order-url',
                    'Order Notification Url',
                    array($this, 'greenstory_order_url'),
                    'gs-settings-general',
                    'notification_general_id'
                );

                add_settings_field( //plugin fields
                    'general-product-enable',
                    'Enable Product Notification',
                    array($this, 'greenstory_product_enable'),
                    'gs-settings-general',
                    'notification_general_id'
                );

                add_settings_field( //plugin fields
                    'general-order-enable',
                    'Enable Order Notification',
                    array($this, 'greenstory_order_enable'),
                    'gs-settings-general',
                    'notification_general_id'
                );

                add_settings_field( //plugin fields
                    'general-product-sync',
                    'Sync all products',
                    array($this, 'greenstory_sync_product'),
                    'gs-settings-general',
                    'notification_general_id'
                );

                // add_settings_field( //plugin fields
                //     'general-product-notification-enable',
                //     'Enable Product Cron Notification',
                //     array($this, 'greenstory_product_cron_enable'),
                //     'gs-settings-general',
                //     'notification_general_id'
                // );

                // add_settings_field( //plugin fields
                //     'general-order-notification-enable',
                //     'Enable Order Cron Notification',
                //     array($this, 'greenstory_order_notification_enable'),
                //     'gs-settings-general',
                //     'notification_general_id'
                // );

                register_setting(
                    'gs-product', // Option group
                    'gs-product', // Option name
                    array($this, 'greenstory_sanitize') // Sanitize
                );

                register_setting('gs-settings-product', 'option_2', 'esc_attr');




                add_settings_section(
                    'setting_section_id', // ID
                    'Product widget', // Title
                    array($this, 'greenstory_section_info'), // Callback
                    'gs-settings-product' // Page
                );

                add_settings_field(
                    'product_hook_value', // id
                    'Page hook', // title
                    array($this, 'greenstory_product_hook_dropdown'), // callback
                    'gs-settings-product', // page
                    'setting_section_id' // section
                );
                add_settings_field(
                    'product_checkbox', // id
                    'Enable widget', // title
                    array($this, 'greenstory_product_checkbox_display'), // callback
                    'gs-settings-product', // page
                    'setting_section_id' // section
                );
                register_setting(
                    'gs-cart', // Option group
                    'gs-cart', // Option name
                    array($this, 'greenstory_sanitize') // Sanitize
                );
                add_settings_section(
                    'setting_section_id', // ID
                    'Cart widget', // Title
                    array($this, 'greenstory_section_info'), // Callback
                    'gs-settings-cart' // Page
                );


                add_settings_field(
                    'cart_hook_value', // id
                    'Page hook', // title
                    array($this, 'greenstory_cart_hook_dropdown'), // callback
                    'gs-settings-cart', // page
                    'setting_section_id' // section
                );
                add_settings_field(
                    'cart_checkbox', // id
                    'Enable widget', // title
                    array($this, 'greenstory_cart_checkbox_display'), // callback
                    'gs-settings-cart', // page
                    'setting_section_id' // section
                );

                /* cart offset */

                register_setting(
                    'gs-cart-offset', // Option group
                    'gs-cart-offset', // Option name
                    array($this, 'greenstory_sanitize') // Sanitize
                );
                add_settings_section(
                    'setting_section_id', // ID
                    'Cart offset widget', // Title
                    array($this, 'greenstory_section_info'), // Callback
                    'gs-settings-cart-offset' // Page
                );

                add_settings_field(
                    'cart_offset_hook_value', // id
                    'Page hook', // title
                    array($this, 'greenstory_cart_offset_hook_dropdown'), // callback
                    'gs-settings-cart-offset', // page
                    'setting_section_id' // section
                );
                add_settings_field(
                    'cart_offset_checkbox', // id
                    'Enable widget', // title
                    array($this, 'greenstory_cart_offset_checkbox_display'), // callback
                    'gs-settings-cart-offset', // page
                    'setting_section_id' // section
                );


                register_setting(
                    'gs-brand-offset', // Option group
                    'gs-brand-offset', // Option name
                    array($this, 'greenstory_sanitize') // Sanitize
                );
                add_settings_section(
                    'setting_section_id', // ID
                    'Brand Offset widget', // Title
                    array($this, 'greenstory_section_info'), // Callback
                    'gs-settings-brand-offset' // Page
                );

                add_settings_field(
                    'brand_offset_hook_value', // id
                    'Widget Tag', // title
                    array($this, 'greenstory_brand_offset_hook_input'), // callback
                    'gs-settings-brand-offset', // page
                    'setting_section_id' // section
                );
                // add_settings_field(
                //     'brand_offset_checkbox', // id
                //     'Enable widget', // title
                //     array($this, 'greenstory_brand_offset_checkbox_display'), // callback
                //     'gs-settings-brand-offset', // page
                //     'setting_section_id' // section
                // );

                register_setting(
                    'gs-customer-impact', // Option group
                    'gs-customer-impact', // Option name
                    array($this, 'greenstory_sanitize') // Sanitize
                );
                add_settings_section(
                    'setting_section_id', // ID
                    'Customer Impact widget', // Title
                    array($this, 'greenstory_section_info'), // Callback
                    'gs-settings-customer-impact' // Page
                );

                add_settings_field(
                    'customer_impact_hook_value', // id
                    'Page hook', // title
                    array($this, 'greenstory_custoomer_impact_hook_dropdown'), // callback
                    'gs-settings-customer-impact', // page
                    'setting_section_id' // section
                );
                add_settings_field(
                    'customer_impact_checkbox', // id
                    'Enable widget', // title
                    array($this, 'greenstory_customer_impact_checkbox_display'), // callback
                    'gs-settings-customer-impact', // page
                    'setting_section_id' // section
                );

                register_setting(
                    'gs-pdp-offset', // Option group
                    'gs-pdp-offset', // Option name
                    array($this, 'greenstory_sanitize') // Sanitize
                );
                add_settings_section(
                    'setting_section_id', // ID
                    'PDP offset widget', // Title
                    array($this, 'greenstory_section_info'), // Callback
                    'gs-settings-pdp-offset' // Page
                );

                add_settings_field(
                    'pdp_offset_hook_value', // id
                    'Page hook', // title
                    array($this, 'greenstory_pdp_offset_hook_dropdown'), // callback
                    'gs-settings-pdp-offset', // page
                    'setting_section_id' // section
                );
                add_settings_field(
                    'pdp_offset_checkbox', // id
                    'Enable widget', // title
                    array($this, 'greenstory_pdp_offset_checkbox_display'), // callback
                    'gs-settings-pdp-offset', // page
                    'setting_section_id' // section
                );

                register_setting(
                    'gs-counter', // Option group
                    'gs-counter', // Option name
                    array($this, 'greenstory_sanitize') // Sanitize
                );
                add_settings_section(
                    'setting_section_id', // ID
                    'Counter widget', // Title
                    array($this, 'greenstory_section_info'), // Callback
                    'gs-settings-counter' // Page
                );


                add_settings_field( // Option 2
                    'counter-hook', // Option ID
                    'Widget tag', // Label
                    array($this, 'greenstory_counter_hook_input'),
                    'gs-settings-counter',  // Page it will be displayed
                    'setting_section_id', // Name of our section (General Settings)
                    array( // The $args
                        'counter-hook' // Should match Option ID
                    )
                );
                // add_settings_field(
                //     'counter_checkbox', // id
                //     'Enable widget', // title
                //     array($this, 'greenstory_counter_checkbox_display'), // callback
                //     'gs-settings-counter', // page
                //     'setting_section_id' // section
                // );

                add_settings_section(
                    'widget_general_id', // ID
                    'Widget', // Title
                    array($this, 'greenstory_section_info'), // Callback
                    'gs-settings-general' // Page
                );

                add_settings_field( //plugin fields
                    'global-widget-id',
                    'Enable Global Widget',
                    array($this, 'greenstory_widget_global_id'),
                    'gs-settings-general',
                    'widget_general_id'
                );

                add_settings_field( //plugin fields
                    'lang-widget-id',
                    'Language',
                    array($this, 'greenstory_widget_lang_id'),
                    'gs-settings-general',
                    'widget_general_id'
                );

                add_settings_field( //plugin fields
                    'locale-widget-id',
                    'Locale',
                    array($this, 'greenstory_widget_locale_id'),
                    'gs-settings-general',
                    'widget_general_id'
                );
            }


            public function greenstory_section_info()
            {
                //your code...
            }

            //callback to display the form input
            public function greenstory_cart_client_id()
            {
                printf(
                    '<input type="text" id="cart-client-id" name="gs-cart[cart-client-id]" value="%s"  required />',
                    isset($this->cart_data['cart-client-id']) ? esc_attr($this->cart_data['cart-client-id']) : ''
                );
            }
            public function greenstory_product_client_id()
            {
                printf(
                    '<input type="text" name="gs-product[product-client-id]" id="product-client-id" value="%s" required /> ',
                    isset($this->product_data['product-client-id']) ? esc_attr($this->product_data['product-client-id']) : ''
                );
            }

            /* general */
            public function greenstory_general_client_id()
            {
                printf(
                    '<input type="text" name="gs-general[general-client-id]" id="general-client-id" value="%s" required style="width:400px" /> ',
                    isset($this->general_data['general-client-id']) ? esc_attr($this->general_data['general-client-id']) : ''
                );
            }

            public function greenstory_general_library_id()
            {
                printf(
                    '<input type="text" name="gs-general[general-library-id]" id="general-library-id" value="%s" required style="width:400px" /> ',
                    isset($this->general_data['general-library-id']) ? esc_attr($this->general_data['general-library-id']) : ''
                );
            }

            // public function greenstory_general_site_id()
            // {
            //     printf(
            //         '<input type="text" name="gs-general[general-site-id]" id="general-site-id" value="%s" required /> ',
            //         isset($this->general_data['general-site-id']) ? esc_attr($this->general_data['general-site-id']) : ''
            //     );
            // }
            public function greenstory_general_enc_key()
            {
                printf(
                    '<input type="text" name="gs-general[general-enc-key]" id="general-enc-key" value="%s" required /> ',
                    isset($this->general_data['general-enc-key']) ? esc_attr($this->general_data['general-enc-key']) : ''
                );
            }
            public function greenstory_general_site_domain()
            {
                printf(
                    '<input type="text" name="gs-general[general-site-domain]" id="general-site-domain" value="%s" required style="width:400px"  /> ',
                    isset($this->general_data['general-site-domain']) ? esc_attr($this->general_data['general-site-domain']) : ''
                );
            }

            public function greenstory_generaly_product_url()
            {
                printf(
                    '<input type="text" name="gs-general[general-product-url]" id="general-product-url" value="%s" style="width:400px" /> ',
                    isset($this->general_data['general-product-url']) ? esc_attr($this->general_data['general-product-url']) : ''
                );
            }

            // public function greenstory_general_interval_days()
            // {
            //     printf(
            //         '<input type="text" name="gs-general[general-interval-days]" id="general-interval-days" value="%s" /> ',
            //         isset($this->general_data['general-interval-days']) ? esc_attr($this->general_data['general-interval-days']) : ''
            //     );
            // }

            public function greenstory_order_url()
            {
                printf(
                    '<input type="text" name="gs-general[general-order-url]" id="general-order-url" value="%s" style="width:400px" /> ',
                    isset($this->general_data['general-order-url']) ? esc_attr($this->general_data['general-order-url']) : ''
                );
            }

            public function greenstory_product_enable()
            {
                $select = getSelectOptions(getYesNo(), $this->general_data, 'general-product-enable');

                printf(
                    $select,
                    isset($this->general_data['general-product-enable']) ? esc_attr($this->general_data['general-product-enable']) : ''
                );
            }

            public function greenstory_order_enable()
            {
                $select = getSelectOptions(getYesNo(), $this->general_data, 'general-order-enable');

                printf(
                    $select,
                    isset($this->general_data['general-order-enable']) ? esc_attr($this->general_data['general-order-enable']) : ''
                );
            }

            public function greenstory_sync_product()
            {
                $select = '<input type="button" onclick="sync()" name="export" id="export" class="button button-primary" value="Start">';

                printf(
                    $select,
                    isset($this->general_data['general-order-enable']) ? esc_attr($this->general_data['general-order-enable']) : ''
                );
            }
            // public function greenstory_product_cron_enable()
            // {

            //     $select = getSelectOptions(getYesNo(), $this->general_data, 'general-product-notification-enable');

            //     printf(
            //         $select,
            //         isset($this->general_data['general-product-notification-enable']) ? esc_attr($this->general_data['general-product-notification-enable']) : ''
            //     );
            // }

            // public function greenstory_order_notification_enable()
            // {
            //     $select = getSelectOptions(getYesNo(), $this->general_data, 'general-order-notification-enable');

            //     printf(
            //         $select,
            //         isset($this->general_data['general-order-notification-enable']) ? esc_attr($this->general_data['general-order-notification-enable']) : ''
            //     );
            // }

            public function greenstory_widget_global_id()
            {
                printf(
                    '<select name="gs-general[global-widget-id]" id="global-widget-id"><option value="Yes" ' . ($this->general_data['global-widget-id'] == "Yes" ? "selected" : "") . ' >Yes</option><option value="No" ' . ($this->general_data['global-widget-id'] == "No" ? "selected" : "") . ' >No</option></select> ',
                    isset($this->general_data['global-widget-id']) ? esc_attr($this->general_data['global-widget-id']) : ''
                );
            }

            public function greenstory_widget_locale_id()
            {
                $select = getSelectOptions(getLocale(), $this->general_data, 'locale-widget-id');

                printf(
                    $select,
                    isset($this->general_data['locale-widget-id']) ? esc_attr($this->general_data['locale-widget-id']) : ''
                );
            }

            public function greenstory_widget_lang_id()
            {
                $select = getSelectOptions(getLanguage(), $this->general_data, 'lang-widget-id');

                printf(
                    $select,
                    isset($this->general_data['lang-widget-id']) ? esc_attr($this->general_data['lang-widget-id']) : ''
                );
            }

            public function greenstory_counter_hook_input()
            {

                $general_data = get_option('gs-general');
                $client_id = "<place client id in general tab>";
                if ($general_data['general-client-id']) {
                    $client_id = $general_data['general-client-id'];
                }


                $html = '<gs-counter lang="' . ($general_data['lang-widget-id'] ?  $general_data['lang-widget-id'] : get_bloginfo("language")) . '" locale="' . ($general_data['locale-widget-id'] ? $general_data['locale-widget-id'] :  get_locale()) . '" clientID="' . trim($client_id) . '"></gs-counter>';

                printf(
                    '<input style="width:650px; font-size:10px" readonly  type="text" name="gs-counter[counter-hook]" id="counter-hook" value="%s" /> <br> Copy this tag to place it in your html code block.',
                    isset($html) ? esc_attr($html) : ''
                );
            }
            // public function greenstory_counter_clinet_id()
            // {
            //     printf(
            //         '<input type="text" name="gs-counter[counter-client-id]" id="counter-client-id" value="%s" /> ',
            //         isset($this->counter_data['counter-client-id']) ? esc_attr($this->counter_data['counter-client-id']) : ''
            //     );
            // }
            public function greenstory_product_hook_dropdown()
            { // product page dropdown hook
                $option = get_option('gs-product');
                ?>
        <select name="gs-product[product_hook_value]" id="product_hook_value">
            <option value="woocommerce_before_single_product" <?php if ($option['product_hook_value'] == 'woocommerce_before_single_product') echo 'selected'; ?>>woocommerce_before_single_product</option>
            <option value="woocommerce_before_single_product_summary" <?php if ($option['product_hook_value'] == 'woocommerce_before_single_product_summary') echo 'selected'; ?>>woocommerce_before_single_product_summary</option>
            <option value="woocommerce_single_product_summary" <?php if ($option['product_hook_value'] == 'woocommerce_single_product_summary') echo 'selected'; ?>>woocommerce_single_product_summary</option>
            <option value="woocommerce_before_add_to_cart_form" <?php if ($option['product_hook_value'] == 'woocommerce_before_add_to_cart_form') echo 'selected'; ?>>woocommerce_before_add_to_cart_form</option>
            <option value="woocommerce_before_variations_form" <?php if ($option['product_hook_value'] == 'woocommerce_before_variations_form') echo 'selected'; ?>>woocommerce_before_variations_form</option>
            <option value="woocommerce_before_add_to_cart_button" <?php if ($option['product_hook_value'] == 'woocommerce_before_add_to_cart_button') echo 'selected'; ?>>woocommerce_before_add_to_cart_button</option>
            <option value="woocommerce_before_single_variation" <?php if ($option['product_hook_value'] == 'woocommerce_before_single_variation') echo 'selected'; ?>>woocommerce_before_single_variation</option>
            <option value="woocommerce_single_variation" <?php if ($option['product_hook_value'] == 'woocommerce_single_variation') echo 'selected'; ?>>woocommerce_single_variation</option>
            <option value="woocommerce_after_add_to_cart_form" <?php if ($option['product_hook_value'] == 'woocommerce_after_add_to_cart_form') echo 'selected'; ?>>woocommerce_after_add_to_cart_form</option>
            <option value="woocommerce_product_meta_start" <?php if ($option['product_hook_value'] == 'woocommerce_product_meta_start') echo 'selected'; ?>>woocommerce_product_meta_start</option>
            <option value="woocommerce_share" <?php if ($option['product_hook_value'] == 'woocommerce_share') echo 'selected'; ?>>woocommerce_share</option>
            <option value="woocommerce_after_single_product_summary" <?php if ($option['product_hook_value'] == 'woocommerce_after_single_product_summary') echo 'selected'; ?>>woocommerce_after_single_product_summary</option>
            <option value="woocommerce_after_single_product" <?php if ($option['product_hook_value'] == 'woocommerce_after_single_product') echo 'selected'; ?>>woocommerce_after_single_product</option>
        </select> <?php
                }

                public function greenstory_cart_hook_dropdown()
                { //cart page dropdown hook
                    $option = get_option('gs-cart');
                    ?>
        <select name="gs-cart[cart_hook_value]" id="cart_hook_value">
            <option value="woocommerce_before_cart" <?php if ($option['cart_hook_value'] == 'woocommerce_before_cart') echo 'selected'; ?>>woocommerce_before_cart</option>
            <option value="woocommerce_before_cart_table" <?php if ($option['cart_hook_value'] == 'woocommerce_before_cart_table') echo 'selected'; ?>>woocommerce_before_cart_table</option>
            <option value="woocommerce_before_cart_contents" <?php if ($option['cart_hook_value'] == 'woocommerce_before_cart_contents') echo 'selected'; ?>>woocommerce_before_cart_contents</option>
            <option value="woocommerce_cart_contents" <?php if ($option['cart_hook_value'] == 'woocommerce_cart_contents') echo 'selected'; ?>>woocommerce_cart_contents</option>
            <option value="woocommerce_cart_coupon" <?php if ($option['cart_hook_value'] == 'woocommerce_cart_coupon') echo 'selected'; ?>>woocommerce_cart_coupon</option>
            <option value="woocommerce_after_cart_contents" <?php if ($option['cart_hook_value'] == 'woocommerce_after_cart_contents') echo 'selected'; ?>>woocommerce_after_cart_contents</option>
            <option value="woocommerce_after_cart_table" <?php if ($option['cart_hook_value'] == 'woocommerce_after_cart_table') echo 'selected'; ?>>woocommerce_after_cart_table</option>
            <option value="woocommerce_cart_collaterals" <?php if ($option['cart_hook_value'] == 'woocommerce_cart_collaterals') echo 'selected'; ?>>woocommerce_cart_collaterals</option>
            <option value="woocommerce_before_cart_totals" <?php if ($option['cart_hook_value'] == 'woocommerce_before_cart_totals') echo 'selected'; ?>>woocommerce_before_cart_totals</option>
            <option value="woocommerce_cart_totals_before_shipping" <?php if ($option['cart_hook_value'] == 'woocommerce_cart_totals_before_shipping') echo 'selected'; ?>>woocommerce_cart_totals_before_shipping</option>
            <option value="woocommerce_before_shipping_calculator" <?php if ($option['cart_hook_value'] == 'woocommerce_before_shipping_calculator') echo 'selected'; ?>>woocommerce_before_shipping_calculator</option>
            <option value="woocommerce_after_shipping_calculator" <?php if ($option['cart_hook_value'] == 'woocommerce_after_shipping_calculator') echo 'selected'; ?>>woocommerce_after_shipping_calculator</option>
            <option value="woocommerce_cart_totals_after_shipping" <?php if ($option['cart_hook_value'] == 'woocommerce_cart_totals_after_shipping') echo 'selected'; ?>>woocommerce_cart_totals_after_shipping</option>
            <option value="woocommerce_cart_totals_before_order_total" <?php if ($option['cart_hook_value'] == 'woocommerce_cart_totals_before_order_total') echo 'selected'; ?>>woocommerce_cart_totals_before_order_total</option>
            <option value="woocommerce_cart_totals_after_order_total" <?php if ($option['cart_hook_value'] == 'woocommerce_cart_totals_after_order_total') echo 'selected'; ?>>woocommerce_cart_totals_after_order_total</option>
            <option value="woocommerce_proceed_to_checkout" <?php if ($option['cart_hook_value'] == 'woocommerce_proceed_to_checkout') echo 'selected'; ?>>woocommerce_proceed_to_checkout</option>
            <option value="woocommerce_after_cart_totals" <?php if ($option['cart_hook_value'] == 'woocommerce_after_cart_totals') echo 'selected'; ?>>woocommerce_after_cart_totals</option>
            <option value="woocommerce_after_cart" <?php if ($option['cart_hook_value'] == 'woocommerce_after_cart') echo 'selected'; ?>>woocommerce_after_cart</option>
        </select> <?php
                }

                // public function greenstory_counter_hook_dropdown()
                // { //cart page dropdown hook
                //     printf(
                //         '<input type="text" name="gs-counter[counter-hook]" id="counter-hook" value="%s" required />',
                //         isset($this->cart_data['cart-client-id']) ? esc_attr($this->cart_data['cart-client-id']) : ''
                //     );
                // }



                function greenstory_product_checkbox_display()
                {
                    $option = get_option('gs-product');
                    ?>
        <input type="checkbox" name="gs-product[product_checkbox]" id="product_checkbox" value="1" <?php checked(1, isset($option['product_checkbox']) ?  $option['product_checkbox'] : null, true); ?> />
    <?php
                }
                function greenstory_cart_checkbox_display()
                {
                    $option = get_option('gs-cart');


    ?>
        <input type="checkbox" name="gs-cart[cart_checkbox]" value="1" <?php checked(1, isset($option['cart_checkbox']) ?  $option['cart_checkbox'] : null, true); ?> />
    <?php
                }
                function greenstory_cart_offset_hook_dropdown()
                {
                    $option = get_option('gs-cart-offset');
    ?>
        <select name="gs-cart-offset[cart_offset_hook_value]" id="cart_offset_hook_value">
            <option value="woocommerce_before_cart" <?php if ($option['cart_offset_hook_value'] == 'woocommerce_before_cart') echo 'selected'; ?>>woocommerce_before_cart</option>
            <option value="woocommerce_before_cart_table" <?php if ($option['cart_offset_hook_value'] == 'woocommerce_before_cart_table') echo 'selected'; ?>>woocommerce_before_cart_table</option>
            <option value="woocommerce_before_cart_contents" <?php if ($option['cart_offset_hook_value'] == 'woocommerce_before_cart_contents') echo 'selected'; ?>>woocommerce_before_cart_contents</option>
            <option value="woocommerce_cart_contents" <?php if ($option['cart_offset_hook_value'] == 'woocommerce_cart_contents') echo 'selected'; ?>>woocommerce_cart_contents</option>
            <option value="woocommerce_cart_coupon" <?php if ($option['cart_offset_hook_value'] == 'woocommerce_cart_coupon') echo 'selected'; ?>>woocommerce_cart_coupon</option>
            <option value="woocommerce_after_cart_contents" <?php if ($option['cart_offset_hook_value'] == 'woocommerce_after_cart_contents') echo 'selected'; ?>>woocommerce_after_cart_contents</option>
            <option value="woocommerce_after_cart_table" <?php if ($option['cart_offset_hook_value'] == 'woocommerce_after_cart_table') echo 'selected'; ?>>woocommerce_after_cart_table</option>
            <option value="woocommerce_cart_collaterals" <?php if ($option['cart_offset_hook_value'] == 'woocommerce_cart_collaterals') echo 'selected'; ?>>woocommerce_cart_collaterals</option>
            <option value="woocommerce_before_cart_totals" <?php if ($option['cart_offset_hook_value'] == 'woocommerce_before_cart_totals') echo 'selected'; ?>>woocommerce_before_cart_totals</option>
            <option value="woocommerce_cart_totals_before_shipping" <?php if ($option['cart_offset_hook_value'] == 'woocommerce_cart_totals_before_shipping') echo 'selected'; ?>>woocommerce_cart_totals_before_shipping</option>
            <option value="woocommerce_before_shipping_calculator" <?php if ($option['cart_offset_hook_value'] == 'woocommerce_before_shipping_calculator') echo 'selected'; ?>>woocommerce_before_shipping_calculator</option>
            <option value="woocommerce_after_shipping_calculator" <?php if ($option['cart_offset_hook_value'] == 'woocommerce_after_shipping_calculator') echo 'selected'; ?>>woocommerce_after_shipping_calculator</option>
            <option value="woocommerce_cart_totals_after_shipping" <?php if ($option['cart_offset_hook_value'] == 'woocommerce_cart_totals_after_shipping') echo 'selected'; ?>>woocommerce_cart_totals_after_shipping</option>
            <option value="woocommerce_cart_totals_before_order_total" <?php if ($option['cart_offset_hook_value'] == 'woocommerce_cart_totals_before_order_total') echo 'selected'; ?>>woocommerce_cart_totals_before_order_total</option>
            <option value="woocommerce_cart_totals_after_order_total" <?php if ($option['cart_offset_hook_value'] == 'woocommerce_cart_totals_after_order_total') echo 'selected'; ?>>woocommerce_cart_totals_after_order_total</option>
            <option value="woocommerce_proceed_to_checkout" <?php if ($option['cart_offset_hook_value'] == 'woocommerce_proceed_to_checkout') echo 'selected'; ?>>woocommerce_proceed_to_checkout</option>
            <option value="woocommerce_after_cart_totals" <?php if ($option['cart_offset_hook_value'] == 'woocommerce_after_cart_totals') echo 'selected'; ?>>woocommerce_after_cart_totals</option>
            <option value="woocommerce_after_cart" <?php if ($option['cart_offset_hook_value'] == 'woocommerce_after_cart') echo 'selected'; ?>>woocommerce_after_cart</option>
        </select>
    <?php
                }
                public function greenstory_brand_offset_hook_input()
                {
                    $general_data = get_option('gs-general');

                    $general_data = get_option('gs-general');
                    $client_id = "<place client id in general tab>";
                    if ($general_data['general-client-id']) {
                        $client_id = $general_data['general-client-id'];
                    }

                    $html = '<gs-brand-offset lang="' . ($general_data['lang-widget-id'] ?  $general_data['lang-widget-id'] : get_bloginfo("language")) . '" locale="' . ($general_data['locale-widget-id'] ? $general_data['locale-widget-id'] :  get_locale()) . '" clientID="' . trim($client_id) . '"></gs-brand-offset>';

                    printf(

                        '<input style="width:650px; font-size:10px" type="text" readonly name="gs-brand-offset[brand_offset_hook_value]" id="brand_offset_hook_value" value="%s" /> <br> Copy this tag to place it in your html code block.',
                        isset($html) ? esc_attr($html) : ''
                    );
                }
                function greenstory_custoomer_impact_hook_dropdown()
                {
                    $option = get_option('gs-customer-impact');
    ?>
        <select name="gs-customer-impact[customer_impact_hook_value]" id="customer_impact_hook_value">

            <option value="woocommerce_before_customer_login_form" <?php if ($option['customer_impact_hook_value'] == 'woocommerce_before_customer_login_form') echo 'selected'; ?>>woocommerce_before_customer_login_form</option>
            <option value="woocommerce_login_form_start" <?php if ($option['customer_impact_hook_value'] == 'woocommerce_login_form_start') echo 'selected'; ?>>woocommerce_login_form_start</option>
            <option value="woocommerce_register_form_start" <?php if ($option['customer_impact_hook_value'] == 'woocommerce_register_form_start') echo 'selected'; ?>>woocommerce_register_form_start</option>
            <option value="woocommerce_login_form" <?php if ($option['customer_impact_hook_value'] == 'woocommerce_login_form') echo 'selected'; ?>>woocommerce_login_form</option>
            <option value="woocommerce_register_form" <?php if ($option['customer_impact_hook_value'] == 'woocommerce_register_form') echo 'selected'; ?>>woocommerce_register_form</option>
            <option value="woocommerce_register_form_end" <?php if ($option['customer_impact_hook_value'] == 'woocommerce_register_form_end') echo 'selected'; ?>>woocommerce_register_form_end</option>
            <option value="woocommerce_login_form_end" <?php if ($option['customer_impact_hook_value'] == 'woocommerce_login_form_end') echo 'selected'; ?>>woocommerce_login_form_end</option>
            <option value="woocommerce_after_customer_login_form" <?php if ($option['customer_impact_hook_value'] == 'woocommerce_after_customer_login_form') echo 'selected'; ?>>woocommerce_after_customer_login_form</option>
            <option value="woocommerce_account_dashboard" <?php if ($option['customer_impact_hook_value'] == 'woocommerce_account_dashboard') echo 'selected'; ?>>woocommerce_account_dashboard</option>
            <option value="woocommerce_before_account_orders_pagination" <?php if ($option['customer_impact_hook_value'] == 'woocommerce_before_account_orders_pagination') echo 'selected'; ?>>woocommerce_before_account_orders_pagination</option>
            <option value="woocommerce_after_account_orders" <?php if ($option['customer_impact_hook_value'] == 'woocommerce_after_account_orders') echo 'selected'; ?>>woocommerce_after_account_orders</option>
            <option value="woocommerce_before_account_downloads" <?php if ($option['customer_impact_hook_value'] == 'woocommerce_before_account_downloads') echo 'selected'; ?>>woocommerce_before_account_downloads</option>
            <option value="woocommerce_before_available_downloads" <?php if ($option['customer_impact_hook_value'] == 'woocommerce_before_available_downloads') echo 'selected'; ?>>woocommerce_before_available_downloads</option>
            <option value="woocommerce_after_available_downloads" <?php if ($option['customer_impact_hook_value'] == 'woocommerce_after_available_downloads') echo 'selected'; ?>>woocommerce_after_available_downloads</option>
            <option value="woocommerce_after_account_downloads" <?php if ($option['customer_impact_hook_value'] == 'woocommerce_after_account_downloads') echo 'selected'; ?>>woocommerce_after_account_downloads</option>
            <option value="woocommerce_before_edit_account_address_form" <?php if ($option['customer_impact_hook_value'] == 'woocommerce_before_edit_account_address_form') echo 'selected'; ?>>woocommerce_before_edit_account_address_form</option>
            <option value="woocommerce_after_edit_account_address_form" <?php if ($option['customer_impact_hook_value'] == 'woocommerce_after_edit_account_address_form') echo 'selected'; ?>>woocommerce_after_edit_account_address_form</option>
            <option value="woocommerce_after_account_navigation" <?php if ($option['customer_impact_hook_value'] == 'woocommerce_after_account_navigation') echo 'selected'; ?>>woocommerce_after_account_navigation</option>
            <option value="woocommerce_account_content" <?php if ($option['customer_impact_hook_value'] == 'woocommerce_account_content') echo 'selected'; ?>>woocommerce_account_content</option>
            <option value="woocommerce_before_edit_account_form" <?php if ($option['customer_impact_hook_value'] == 'woocommerce_before_edit_account_form') echo 'selected'; ?>>woocommerce_before_edit_account_form</option>
            <option value="woocommerce_edit_account_form_start" <?php if ($option['customer_impact_hook_value'] == 'woocommerce_edit_account_form_start') echo 'selected'; ?>>woocommerce_edit_account_form_start</option>
            <option value="woocommerce_edit_account_form" <?php if ($option['customer_impact_hook_value'] == 'woocommerce_edit_account_form') echo 'selected'; ?>>woocommerce_edit_account_form</option>
            <option value="woocommerce_edit_account_form_end" <?php if ($option['customer_impact_hook_value'] == 'woocommerce_edit_account_form_end') echo 'selected'; ?>>woocommerce_edit_account_form_end</option>
            <option value="woocommerce_after_edit_account_form" <?php if ($option['customer_impact_hook_value'] == 'woocommerce_after_edit_account_form') echo 'selected'; ?>>woocommerce_after_edit_account_form</option>

        </select>
    <?php
                }
                function greenstory_pdp_offset_hook_dropdown()
                {
                    $option = get_option('gs-pdp-offset');
    ?>

        <select name="gs-pdp-offset[pdp_offset_hook_value]" id="gs-pdp-offset">
            <option value="woocommerce_before_single_product" <?php if ($option['pdp_offset_hook_value'] == 'woocommerce_before_single_product') echo 'selected'; ?>>woocommerce_before_single_product</option>
            <option value="woocommerce_before_single_product_summary" <?php if ($option['pdp_offset_hook_value'] == 'woocommerce_before_single_product_summary') echo 'selected'; ?>>woocommerce_before_single_product_summary</option>
            <option value="woocommerce_single_product_summary" <?php if ($option['pdp_offset_hook_value'] == 'woocommerce_single_product_summary') echo 'selected'; ?>>woocommerce_single_product_summary</option>
            <option value="woocommerce_before_add_to_cart_form" <?php if ($option['pdp_offset_hook_value'] == 'woocommerce_before_add_to_cart_form') echo 'selected'; ?>>woocommerce_before_add_to_cart_form</option>
            <option value="woocommerce_before_variations_form" <?php if ($option['pdp_offset_hook_value'] == 'woocommerce_before_variations_form') echo 'selected'; ?>>woocommerce_before_variations_form</option>
            <option value="woocommerce_before_add_to_cart_button" <?php if ($option['pdp_offset_hook_value'] == 'woocommerce_before_add_to_cart_button') echo 'selected'; ?>>woocommerce_before_add_to_cart_button</option>
            <option value="woocommerce_before_single_variation" <?php if ($option['pdp_offset_hook_value'] == 'woocommerce_before_single_variation') echo 'selected'; ?>>woocommerce_before_single_variation</option>
            <option value="woocommerce_single_variation" <?php if ($option['pdp_offset_hook_value'] == 'woocommerce_single_variation') echo 'selected'; ?>>woocommerce_single_variation</option>
            <option value="woocommerce_after_add_to_cart_form" <?php if ($option['pdp_offset_hook_value'] == 'woocommerce_after_add_to_cart_form') echo 'selected'; ?>>woocommerce_after_add_to_cart_form</option>
            <option value="woocommerce_product_meta_start" <?php if ($option['pdp_offset_hook_value'] == 'woocommerce_product_meta_start') echo 'selected'; ?>>woocommerce_product_meta_start</option>
            <option value="woocommerce_share" <?php if ($option['pdp_offset_hook_value'] == 'woocommerce_share') echo 'selected'; ?>>woocommerce_share</option>
            <option value="woocommerce_after_single_product_summary" <?php if ($option['pdp_offset_hook_value'] == 'woocommerce_after_single_product_summary') echo 'selected'; ?>>woocommerce_after_single_product_summary</option>
            <option value="woocommerce_after_single_product" <?php if ($option['pdp_offset_hook_value'] == 'woocommerce_after_single_product') echo 'selected'; ?>>woocommerce_after_single_product</option>
        </select>
    <?php
                }

                function greenstory_cart_offset_checkbox_display()
                {
                    $option = get_option('gs-cart-offset');
    ?>
        <input type="checkbox" name="gs-cart-offset[cart_offset_checkbox]" value="1" <?php checked(1,  isset($option['cart_offset_checkbox']) ?  $option['cart_offset_checkbox'] : null, true); ?> />
    <?php
                }
                function greenstory_counter_checkbox_display()
                {
                    $option = get_option('gs-counter');
    ?>
        <input type="checkbox" name="gs-counter[counter_checkbox]" value="1" <?php checked(1, isset($option['counter_checkbox']) ?  $option['counter_checkbox'] : null, true); ?> />
    <?php
                }


                function greenstory_brand_offset_checkbox_display()
                {
                    $option = get_option('gs-brand-offset');
    ?>
        <input type="checkbox" name="gs-brand-offset[brand_offset_checkbox]" value="1" <?php checked(1, isset($option['brand_offset_checkbox']) ?  $option['brand_offset_checkbox'] : null, true); ?> />
    <?php
                }

                function greenstory_customer_impact_checkbox_display()
                {
                    $option = get_option('gs-customer-impact');
    ?>
        <input type="checkbox" name="gs-customer-impact[customer_impact_checkbox]" value="1" <?php checked(1, isset($option['customer_impact_checkbox']) ?  $option['customer_impact_checkbox'] : null, true); ?> />
    <?php
                }

                function greenstory_pdp_offset_checkbox_display()
                {
                    $option = get_option('gs-pdp-offset');
    ?>
        <input type="checkbox" name="gs-pdp-offset[pdp_offset_checkbox]" value="1" <?php checked(1, isset($option['pdp_offset_checkbox']) ?  $option['pdp_offset_checkbox'] : null, true); ?> />
<?php
                }
                //sanitize form on submit
                public function greenstory_sanitize($input)
                {
                    $form_error = new WP_Error;
                    $new_input = array();
                    if (empty($input['cart-client-id']) || empty($input['product-client-id']) || empty($input['counter-hook']) || empty($input['counter-client-id'])) {
                        $form_error->add('field', 'No field should be left empty');
                    }
                    if (isset($input['cart-client-id']))
                        $new_input['cart-client-id'] = sanitize_text_field($input['cart-client-id']);
                    if (isset($input['product-client-id']))
                        $new_input['product-client-id'] = sanitize_text_field($input['product-client-id']);

                    // if (isset($input['counter-hook']))
                    //     $new_input['counter-hook'] = sanitize_text_field($input['counter-hook']);
                    if (isset($input['counter_checkbox']))
                        $new_input['counter_checkbox'] = sanitize_text_field($input['counter_checkbox']);

                    if (isset($input['product_hook_value']))
                        $new_input['product_hook_value'] = sanitize_text_field($input['product_hook_value']);
                    if (isset($input['product_checkbox']))
                        $new_input['product_checkbox'] = sanitize_text_field($input['product_checkbox']);

                    if (isset($input['cart_hook_value']))
                        $new_input['cart_hook_value'] = sanitize_text_field($input['cart_hook_value']);
                    if (isset($input['cart_checkbox']))
                        $new_input['cart_checkbox'] = sanitize_text_field($input['cart_checkbox']);

                    if (isset($input['cart_offset_hook_value']))
                        $new_input['cart_offset_hook_value'] = sanitize_text_field($input['cart_offset_hook_value']);
                    if (isset($input['cart_offset_checkbox']))
                        $new_input['cart_offset_checkbox'] = sanitize_text_field($input['cart_offset_checkbox']);

                    // if (isset($input['brand_offset_hook_value']))
                    //     $new_input['brand_offset_hook_value'] = sanitize_text_field($input['brand_offset_hook_value']);
                    if (isset($input['brand_offset_checkbox']))
                        $new_input['brand_offset_checkbox'] = sanitize_text_field($input['brand_offset_checkbox']);

                    if (isset($input['customer_impact_hook_value']))
                        $new_input['customer_impact_hook_value'] = sanitize_text_field($input['customer_impact_hook_value']);
                    if (isset($input['customer_impact_checkbox']))
                        $new_input['customer_impact_checkbox'] = sanitize_text_field($input['customer_impact_checkbox']);

                    if (isset($input['pdp_offset_hook_value']))
                        $new_input['pdp_offset_hook_value'] = sanitize_text_field($input['pdp_offset_hook_value']);
                    if (isset($input['pdp_offset_checkbox']))
                        $new_input['pdp_offset_checkbox'] = sanitize_text_field($input['pdp_offset_checkbox']);

                    //general
                    if (isset($input['general-client-id']))
                        $new_input['general-client-id'] = sanitize_text_field($input['general-client-id']);
                    if (isset($input['general-library-id']))
                        $new_input['general-library-id'] = sanitize_text_field($input['general-library-id']);
                    if (isset($input['general-site-id']))
                        $new_input['general-site-id'] = sanitize_text_field($input['general-site-id']);
                    if (isset($input['general-enc-key']))
                        $new_input['general-enc-key'] = sanitize_text_field($input['general-enc-key']);
                    if (isset($input['general-site-domain']))
                        $new_input['general-site-domain'] = sanitize_text_field($input['general-site-domain']);
                    if (isset($input['general-product-url']))
                        $new_input['general-product-url'] = sanitize_text_field($input['general-product-url']);
                    if (isset($input['general-interval-days']))
                        $new_input['general-interval-days'] = sanitize_text_field($input['general-interval-days']);
                    if (isset($input['general-order-url']))
                        $new_input['general-order-url'] = sanitize_text_field($input['general-order-url']);
                    if (isset($input['general-product-enable']))
                        $new_input['general-product-enable'] = sanitize_text_field($input['general-product-enable']);
                    if (isset($input['general-order-enable']))
                        $new_input['general-order-enable'] = sanitize_text_field($input['general-order-enable']);
                    if (isset($input['general-product-notification-enable']))
                        $new_input['general-product-notification-enable'] = sanitize_text_field($input['general-product-notification-enable']);
                    if (isset($input['general-order-notification-enable']))
                        $new_input['general-order-notification-enable'] = sanitize_text_field($input['general-order-notification-enable']);
                    if (isset($input['global-widget-id']))
                        $new_input['global-widget-id'] = sanitize_text_field($input['global-widget-id']);
                    if (isset($input['locale-widget-id']))
                        $new_input['locale-widget-id'] = sanitize_text_field($input['locale-widget-id']);
                    if (isset($input['lang-widget-id']))
                        $new_input['lang-widget-id'] = sanitize_text_field($input['lang-widget-id']);


                    if (is_wp_error($form_error)) {
                        foreach ($form_error->get_error_messages() as $error) {
                            echo '<div>';
                            echo '<strong>ERROR</strong>:';
                            echo $error . '<br/>';
                            echo '</div>';
                        }
                    }

                    return $new_input;
                }
            }
