<?php
function prepareOrderRequestBody($order_id)
{
    $general_data = get_option('gs-general');
    $order = wc_get_order($order_id);
    $reqBody = array(
        'id' => $order->get_id(),
        'email' => $order->get_billing_email(),
        'created_at' => gmdate("Y-m-d\TH:i:s"),
        'updated_at' => gmdate("Y-m-d\TH:i:s"),
        'name' => $order->get_billing_first_name(),
        "domain" => $general_data['general-site-domain'] ? trim($general_data['general-site-domain']) : get_permalink(woocommerce_get_page_id('shop')),
        'customer_locale' => NULL,
        'browser_ip' => null,
        'order_number' => $order->get_order_number(),
        'source_name' => null,
        'fulfillment_status' => $order->get_status(),
        'contact_email' => $order->get_billing_email(),
        'total_weight' => NULL,
        'line_items' =>
        getProduct($order),
        'shipping_lines' =>
        getShippingMethodObject($order),
        'shipping_address' =>
        createShippingObject($order),
        'customer' =>
        createCustomerObject($order)
    );
    return $reqBody;
}

function createCustomerObject($order)
{
    try {
        $customer = new WC_Customer($order->get_customer_id());
        $customerObj = array(
            'id' =>  null,
            'email' =>  $customer->get_email(),
            'created_at' =>  $customer->get_date_created(),
            'updated_at' => $customer->get_date_modified(),
            'first_name' => $customer->get_first_name(),
            'last_name' => $customer->get_last_name(),
            'currency' => null,
            'buyer_accepts_marketing' => null,
        );
        return $customerObj;
    } catch (Exception $e) {
        log_info($e->getMessage());
        return [];
    }
}

function createShippingObject($order)
{

    try {
        $shippingAddressObj = array(
            'first_name' => $order->get_shipping_first_name(),
            'address1' => $order->get_shipping_address_1(),
            'phone' => $order->get_billing_phone(),
            'city' => $order->get_billing_city(),
            'zip' =>  $order->get_billing_postcode(),
            'province' => $order->get_billing_state(),
            'country' =>  $order->get_shipping_country(),
            'last_name' => $order->get_shipping_last_name(),
            'address2' => $order->get_shipping_address_2(),
            'company' => $order->get_billing_company(),
            'latitude' => null,
            'longitude' => null,
            'name' => null,
            'country_code' => $order->get_shipping_country(),
            'province_code' => $order->get_billing_postcode(),
        );
        return $shippingAddressObj;
    } catch (Exception $e) {
        log_info($e->getMessage());
        return [];
    }
}

function getShippingMethodObject($order)
{

    try {
        $shippingAddressMethodObj = array(
            'id' => NULL,
            'title' => $order->get_shipping_method(),
            'code' => null,
            'carrier_identifier' => null,
        );

        return $shippingAddressMethodObj;
    } catch (Exception $e) {
        log_info($e->getMessage());
        return [];
    }
}

function getProduct($order)
{
    $productsObj = [];
    try {
        foreach ($order->get_items() as $item_key => $item) {

            $product      = $item->get_product();

            $productsObj[] = array(
                'id' =>  $item->get_id(),
                'product_id' => $item->get_product_id(),
                'variant_id' => $item->get_variation_id(),
                'title' => $item->get_name(),
                'quantity' =>  $item->get_quantity(),
                'grams' => $item->get_quantity(),
                'sku' => $product->get_sku(),
                'variant_title' => $item->get_name(),
                'gift_card' => null,
                'fulfillment_status' => null
            );
        }
        return $productsObj;
    } catch (Exception $e) {
        log_info($e->getMessage());
        return [];
    }
}
