<?php

function getTextBetweenTags($string, $tagname)
{
    $pattern = "/<$tagname ?.*>(.*)<\/$tagname>/";
    preg_match($pattern, $string, $matches);
    return $matches[1];
}

function commaseparated($str)
{
    $strArray = explode("|", $str);

    $commaText = [];
    foreach ($strArray as $str) {

        $commaText[] = getTextBetweenTags($str, "a");
    }

    return implode(",", $commaText);
}

function prepareProductRequestBody($product_id)
{

    try {
        $general_data = get_option('gs-general');

        $product = wc_get_product($product_id);


        if ($product->is_type('variable')) {
            $variants = $product->get_available_variations();

            $variantsData = null;
            if (count($variants)) {
                foreach ($variants as $child) {
                    $variantsData[] = [
                        "id" => $child["variation_id"],
                        "product_id" => $product->get_id(),
                        "title" => $child["sku"],
                        "created_at" => $product->get_date_created(),
                        "updated_at" => $product->get_date_modified()
                    ];
                }
            }
        }



        $response["products"][] =  [
            "id" => $product->get_id(),
            "title" =>  $product->get_name(),
            "body_html" => $product->get_description(),
            "vendor" => null,
            //"site_id" => $general_data['general-site-id'],
            "domain" => $general_data['general-site-domain'],
            "product_type" => commaseparated(wc_get_product_category_list($product->get_id(), "|")), //categories
            "created_at" => $product->get_date_created(),
            "updated_at" => $product->get_date_modified(),
            "published_at" => null,
            "tags" => commaseparated(wc_get_product_tag_list($product->get_id(), "|")),
            "variants" => $variantsData,
            "images" => [
                "id" => null,
                "product_id" => $product->get_id(),
                "alt" => null,
                "src" =>  getImageURL($product->get_image())
            ]
        ];
        return $response;
    } catch (Exception $e) {
        log_info($e->getMessage());
        return [];
    }
}

function getImageURL($image)
{
    $string = $image;
    preg_match('/<img(.*)src(.*)=(.*)"(.*)"/U', $string, $result);
    return array_pop($result);
}

function pushProduct($prodBatchArr)
{
    try {
        foreach ($prodBatchArr as $prodObj) {
            $requestBody['products'][] = prepareProductRequestBody($prodObj)['products'][0];
        }
        if (!$requestBody) {
            return;
        }

        $general_data = get_option('gs-general');
        return $response = makeRequest("POST", $general_data['general-product-url'], json_encode($requestBody));
    } catch (Exception $e) {
        log_info($e->getMessage());
        return [];
    }
}

function syncAllProduct()
{
    try {
        $args = array(
            'status' => 'publish',
            'limit' => -1
        );
        $productData = wc_get_products($args);

        $prodCnt = 0;
        $batchCnt = 0;
        $prodBatchArr = [];

        if (count($productData) > 0) {
            //$this->_logger->info("----------Sync All Products Total Count -" . count($productData) . "---------");
        }
        foreach ($productData as $prodObj) {

            $prodBatchArr[] = $prodObj;
            $prodCnt++;
            if ($prodCnt == 50) {



                $response = pushProduct($prodBatchArr);
                // $this->_logger->info("----------Sync All Products Response Body Batch -" . $batchCnt . "---------");
                // $this->_logger->info(json_encode($response));
                $prodCnt = 0;
                $prodBatchArr = [];
                $batchCnt++;
                sleep(3);
            }
        }

        if (count($prodBatchArr) > 0) {
            $response = pushProduct($prodBatchArr);
            // $this->_logger->info("----------Sync All Products last batch ---" . count($prodBatchArr) . "------");
            // $this->_logger->info(json_encode($response));
        }

        echo "success";
    } catch (Exception $e) {
        log_info($e->getMessage());
        echo "failed";
    }
}
