<?php
function makeRequest($method, $apiUrl, $requestBody)
{
    $general_data = get_option('gs-general');
    try {
        $curl = curl_init();
        $header = array(
            'Content-Type: application/json',
            'x-wc-webhook-source: ' . trim($general_data['general-site-domain']),
            'x-wc-webhook-signature: ' . base64_encode(hash_hmac("sha256", $requestBody, trim($general_data['general-enc-key']), true))
        );
        curl_setopt_array($curl, array(
            CURLOPT_URL => trim($apiUrl),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => $method,
            CURLOPT_POSTFIELDS => $requestBody,
            CURLOPT_HEADER => true,
            CURLOPT_HTTPHEADER => $header,
        ));

        log_info("---CURL request---");
        $response = curl_exec($curl);
        log_info("---api url---");
        log_info($apiUrl);
        log_info("---Header---");
        log_info(json_encode($header));
        log_info("---request body---");
        log_info($requestBody);
        $info = curl_getinfo($curl);
        log_info("---curl info---");
        log_info(json_encode($info));
        curl_close($curl);
        log_info("---response body---");
        log_info($response);
        log_info("---CURL closed---");

        return $response;
    } catch (\Exception $e) {
        log_info("---CURL error---");
        log_info($e->getMessage());

        return $e->getMessage();
    }
}
