<?php
defined( 'ABSPATH' ) || die( 'Cheatin&#8217; uh?' );

if ( function_exists( 'seopress_get_toggle_xml_sitemap_option' ) && 1 === (int) seopress_get_toggle_xml_sitemap_option() ) :

	/**
	 * Improvement with SEOPress: auto-detect the XML sitemaps for the preload option
	 *
	 * @since 3.3.6
	 * @author Benjamin Denis
	 * @source ./yoast-seo.php (Remy Perona)
	 */
	if ( function_exists( 'seopress_xml_sitemap_general_enable_option' ) && 1 === (int) seopress_xml_sitemap_general_enable_option() ) {
		/**
		 * Add SEOPress sitemap option to WP Rocket default options
		 *
		 * @since 3.3.6
		 * @author Benjamin Denis
		 * @source ./yoast-seo.php (Remy Perona)
		 *
		 * @param array $options WP Rocket options array.
		 * @return array Updated WP Rocket options array
		 */
		function rocket_add_seopress_sitemap_option( $options ) {
			$options['seopress_xml_sitemap'] = 0;

			return $options;
		}
		add_filter( 'rocket_first_install_options', 'rocket_add_seopress_sitemap_option' );

		/**
		 * Sanitize SEOPress sitemap option value
		 *
		 * @since 3.3.6
		 * @author Benjamin Denis
		 * @source ./yoast-seo.php (Remy Perona)
		 *
		 * @param array $inputs WP Rocket inputs array.
		 * @return array Sanitized WP Rocket inputs array
		 */
		function rocket_seopress_sitemap_option_sanitize( $inputs ) {
			$inputs['seopress_xml_sitemap'] = ! empty( $inputs['seopress_xml_sitemap'] ) ? 1 : 0;

			return $inputs;
		}
		add_filter( 'rocket_inputs_sanitize', 'rocket_seopress_sitemap_option_sanitize' );

		/**
		 * Add SEOPress sitemap URL to the sitemaps to preload
		 *
		 * @since 3.3.6
		 * @author Benjamin Denis
		 * @source ./yoast-seo.php (Remy Perona)
		 *
		 * @param array $sitemaps Sitemaps to preload.
		 * @return array Updated Sitemaps to preload
		 */
		function rocket_add_seopress_sitemap( $sitemaps ) {
			if ( get_rocket_option( 'seopress_xml_sitemap', false ) ) {
				$sitemaps[] = get_home_url() . '/sitemaps.xml';
			}

			return $sitemaps;
		}
		add_filter( 'rocket_sitemap_preload_list', 'rocket_add_seopress_sitemap' );

		/**
		 * Add SEOPress option to WP Rocket settings
		 *
		 * @since 3.3.6
		 * @author Benjamin Denis
		 * @source ./yoast-seo.php (Remy Perona)
		 *
		 * @param array $options WP Rocket settings array.
		 * @return array Updated WP Rocket settings array
		 */
		function rocket_sitemap_preload_seopress_option( $options ) {
			$options['seopress_xml_sitemap'] = [
				'type'              => 'checkbox',
				'container_class'   => [
					'wpr-field--children',
				],
				'label'             => __( 'SEOPress XML sitemap', 'rocket' ),
				// translators: %s = Name of the plugin.
				'description'       => sprintf( __( 'We automatically detected the sitemap generated by the %s plugin. You can check the option to preload it.', 'rocket' ), 'SEOPress' ),
				'parent'            => 'sitemap_preload',
				'section'           => 'preload_section',
				'page'              => 'preload',
				'default'           => 0,
				'sanitize_callback' => 'sanitize_checkbox',
			];

			return $options;
		}
		add_filter( 'rocket_sitemap_preload_options', 'rocket_sitemap_preload_seopress_option' );
	}
endif;
