<?php
/**
 * The template for displaying Author Archive pages
 *
 * Used to display archive-type pages for posts by an author.
 *
 * @link http://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage oxelar_Themes
 * @since Road Themes 1.0
 */

$oxelar_opt = get_option( 'oxelar_opt' );

get_header();

if(isset($oxelar_opt)){
	$bloglayout = 'nosidebar';
} else {
	$bloglayout = 'sidebar';
}
if(isset($oxelar_opt['blog_layout']) && $oxelar_opt['blog_layout']!=''){
	$bloglayout = $oxelar_opt['blog_layout'];
}
if(isset($_GET['layout']) && $_GET['layout']!=''){
	$bloglayout = $_GET['layout'];
}
$blogsidebar = 'right';
if(isset($oxelar_opt['sidebarblog_pos']) && $oxelar_opt['sidebarblog_pos']!=''){
	$blogsidebar = $oxelar_opt['sidebarblog_pos'];
}
if(isset($_GET['sidebar']) && $_GET['sidebar']!=''){
	$blogsidebar = $_GET['sidebar'];
}
switch($bloglayout) {
	case 'sidebar':
		$blogclass = 'blog-sidebar';
		$blogcolclass = 9;
		Oxelar::oxelar_post_thumbnail_size('oxelar-category-thumb');
		break;
	default:
		$blogclass = 'blog-nosidebar';
		$blogcolclass = 12;
		$blogsidebar = 'none';
		Oxelar::oxelar_post_thumbnail_size('oxelar-post-thumb');
}
?>
<div class="main-container"> 
	<div class="container-box"> 
		<div class="blog_header"> 
			<header class="entry-header"> 
				<h1 class="entry-title"><?php if(isset($oxelar_opt)) { echo esc_html($oxelar_opt['blog_header_text']); } else { esc_html_e('Blog', 'oxelar');}  ?></h1>
				
			</header>
			<?php Oxelar::oxelar_breadcrumb(); ?>

		</div>
		<div class="container">
			<div class="row">
				<?php if($blogsidebar=='left') : ?>
					<?php get_sidebar(); ?>
				<?php endif; ?>
				<div class="col-xs-12 <?php echo 'col-md-'.$blogcolclass; ?>">
					<div class="page-content blog-page <?php echo esc_attr($blogclass); if($blogsidebar=='left') {echo ' left-sidebar'; } if($blogsidebar=='right') {echo ' right-sidebar'; } ?>">
						<?php if ( have_posts() ) : ?>

							<?php
								/* Queue the first post, that way we know
								 * what author we're dealing with (if that is the case).
								 *
								 * We reset this later so we can run the loop
								 * properly with a call to rewind_posts().
								 */
								the_post();
							?>

							<header class="archive-header">
								<h1 class="archive-title"><?php printf( esc_html__( 'Author Archives: %s', 'oxelar' ), '<span class="vcard"><a class="url fn n" href="' . esc_url( get_author_posts_url( get_the_author_meta( "ID" ) ) ) . '" title="' . esc_attr( get_the_author() ) . '" rel="me">' . get_the_author() . '</a></span>' ); ?></h1>
							</header><!-- .archive-header -->

							<?php
								/* Since we called the_post() above, we need to
								 * rewind the loop back to the beginning that way
								 * we can run the loop properly, in full.
								 */
								rewind_posts();
							?>

							<?php
							// If a user has filled out their description, show a bio on their entries.
							if ( get_the_author_meta( 'description' ) ) : ?>
							<div class="author-info archives">
								<div class="author-avatar">
									<?php
									/**
									 * Filter the author bio avatar size.
									 *
									 * @since Road Themes 1.0
									 *
									 * @param int $size The height and width of the avatar in pixels.
									 */
									$author_bio_avatar_size = apply_filters( 'oxelar_author_bio_avatar_size', 68 );
									echo get_avatar( get_the_author_meta( 'user_email' ), $author_bio_avatar_size );
									?>
								</div><!-- .author-avatar -->
								<div class="author-description">
									<h2><?php printf( esc_html__( 'About %s', 'oxelar' ), get_the_author() ); ?></h2>
									<p><?php the_author_meta( 'description' ); ?></p>
								</div><!-- .author-description	-->
							</div><!-- .author-info -->
							<?php endif; ?>

							<?php /* Start the Loop */ ?>
							<?php while ( have_posts() ) : the_post(); ?>
								<?php get_template_part( 'content', get_post_format() ); ?>
							<?php endwhile; ?>
							
							<div class="pagination">
								<?php Oxelar::oxelar_pagination(); ?>
							</div>

						<?php else : ?>
							<?php get_template_part( 'content', 'none' ); ?>
						<?php endif; ?>
					</div>
				</div>
				<?php if( $blogsidebar=='right') : ?>
					<?php get_sidebar(); ?>
				<?php endif; ?>
			</div>
		</div>
	</div>
</div>
<?php get_footer(); ?>