<?php
/**
 * The template for displaying posts in the Audio post format
 *
 * Used for both single and index/archive/search.
 *
 * @package WordPress
 * @subpackage oxelar_Themes
 * @since Huge Shop 1.0
 */

$oxelar_opt = get_option( 'oxelar_opt' );

$oxelar_postthumb = Oxelar::oxelar_post_thumbnail_size('');
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	 
	<?php if ( ! post_password_required() && ! is_attachment() ) : ?>
	<?php 
		if ( is_single() ) { ?>
			<div class="post-thumbnail">
				<?php the_post_thumbnail(); ?> 
			</div>
			<div class="player"><?php echo do_shortcode(get_post_meta( $post->ID, '_oxelar_post_intro', true )); ?></div>
		<?php }
	?>
	<?php if ( !is_single() ) { ?>
		<?php if ( has_post_thumbnail() ) { ?>
		<div class="post-thumbnail">
			<a href="<?php the_permalink(); ?>"><?php the_post_thumbnail($oxelar_postthumb); ?></a>
			 
		</div>
		<?php } ?>
	<?php } ?>
	<?php endif; ?>
	
	<div class="postinfo-wrapper <?php if ( !has_post_thumbnail() ) { echo 'no-thumbnail';} ?>">
		
		<div class="post-info"> 
			<header class="entry-header">
				<?php if ( is_single() ) : ?> 
					
					<span class="post-author">
						<span class="post-by"><?php esc_html_e('Posts by', 'oxelar');?> : </span>
						<?php printf( get_the_author() ); ?>
					</span>
					<span class="post-separator">|</span>
					<span class="post-date">
						<?php echo '<span class="month">'.get_the_date('M', $post->ID).'</span><span class="day">'.get_the_date('d', $post->ID).'</span><span class="year">'.get_the_date('Y', $post->ID).'</span>' ;?>
					</span>
					<h1 class="entry-title"><?php the_title(); ?></h1>
				<?php else : ?>  
					<span class="post-author">
						<span class="post-by"><?php esc_html_e('Posts by', 'oxelar');?> : </span>
						<?php printf( get_the_author() ); ?>
					</span>
					<span class="post-separator">|</span>
					<span class="post-date">
						<?php echo '<span class="month">'.get_the_date('M', $post->ID).'</span><span class="day">'.get_the_date('d', $post->ID).'</span><span class="year">'.get_the_date('Y', $post->ID).'</span>' ;?>
					</span>
					<h1 class="entry-title">
						<a href="<?php the_permalink(); ?>" rel="bookmark"><?php the_title(); ?></a>
					</h1>
				<?php endif; ?>
			</header>
			<?php if ( is_single() ) : ?>
				<div class="entry-content">
					<?php the_content( wp_kses(__( 'Continue reading <span class="meta-nav">&rarr;</span>', 'oxelar' ), array('span'=>array('class'=>array())) )); ?>
					<?php wp_link_pages( array( 'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'oxelar' ), 'after' => '</div>', 'pagelink' => '<span>%</span>' ) ); ?>
				</div>
			<?php else : ?>
				<div class="entry-summary">
					<div class="player"><?php echo do_shortcode(get_post_meta( $post->ID, '_oxelar_meta_value_key', true )); ?></div>
					<?php the_excerpt(); ?>
					<a class="readmore button" href="<?php the_permalink(); ?>"><?php if(isset($oxelar_opt['readmore_text']) && $oxelar_opt['readmore_text']!=''){ echo esc_html($oxelar_opt['readmore_text']); } else { esc_html_e('Read more', 'oxelar');}  ?></a>
					 
				</div>
			<?php endif; ?>
			
			<?php if ( is_single() ) : ?>
				<div class="entry-meta">
					<?php oxelar::oxelar_entry_meta(); ?>
				</div>
			
				<?php if( function_exists('oxelar_blog_sharing') ) { ?>
					<div class="social-sharing"><?php oxelar_blog_sharing(); ?></div>
				<?php } ?>
			
				<?php if(get_the_author_meta()!="") { ?>
				<div class="author-info">
					<div class="author-avatar">
						<?php
						$author_bio_avatar_size = apply_filters( 'roadthemes_author_bio_avatar_size', 68 );
						echo get_avatar( get_the_author_meta( 'user_email' ), $author_bio_avatar_size );
						?>
					</div>
					<div class="author-description">
						<h2><?php esc_html_e( 'About the Author:', 'oxelar'); printf( '<a href="'.esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ).'" rel="author">%s</a>' , get_the_author()); ?></h2>
						<p><?php the_author_meta( 'description' ); ?></p>
					</div>
				</div> 
				<?php } ?>
				 
			<?php endif; ?>
		</div>
	</div>
</article>