<?php
/**
 * The template for displaying the footer
 *
 * Contains footer content and the closing of the #main and #page div elements.
 *
 * @package WordPress
 * @subpackage oxelar_Themes
 * @since Road Themes 1.0
 */
$oxelar_opt = get_option( 'oxelar_opt' );

?>
		<div class="footer">
			<?php
			if ( isset($oxelar_opt['footer_layout']) && $oxelar_opt['footer_layout']!="" ) {

				$jscomposer_templates_args = array(
					'orderby'          => 'title',
					'order'            => 'ASC',
					'post_type'        => 'templatera',
					'post_status'      => 'publish',
				);
				$jscomposer_templates = get_posts( $jscomposer_templates_args );

				if(count($jscomposer_templates) > 0) {
					foreach($jscomposer_templates as $jscomposer_template){
						if($jscomposer_template->post_title == $oxelar_opt['footer_layout']){
							echo do_shortcode($jscomposer_template->post_content);
						}
					}
				}
			} else { ?>
				<div class="widget-copyright default-copyright">
					<?php 
					if( isset($oxelar_opt['copyright']) && $oxelar_opt['copyright']!='' ) {
						echo wp_kses($oxelar_opt['copyright'], array(
							'a' => array(
								'href' => array(),
								'title' => array()
							),
							'br' => array(),
							'em' => array(),
							'strong' => array(),
						));
					} else {
						echo 'Copyright <a href="'.esc_url( home_url( '/' ) ).'">'.get_bloginfo('name').'</a> '.date('Y').'. All Rights Reserved';
					}
					?>
				</div>
			<?php
			}
			?>
		</div>
		</div><!-- .page -->  
	</div><!-- .wrapper -->
	<?php if ( isset($oxelar_opt['back_to_top']) && $oxelar_opt['back_to_top'] ) { ?>
	<div id="back-top" class="hidden-xs hidden-sm hidden-md"></div>
	<?php } ?>
	<?php wp_footer(); ?>
</body>
</html>