<?php
/**
 * The Header template for our theme
 *
 * Displays all of the <head> section and everything up till <div id="main">
 *
 * @package WordPress
 * @subpackage oxelar_Themes
 * @since Road Themes 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<?php $oxelar_opt = get_option( 'oxelar_opt' ); ?>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11" />
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
<script type="text/javascript">
   var hi = documnet.getElementById("mzCrA1119705039499").style.display = 'none';
</script>
<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<div class="wrapper <?php if($oxelar_opt['page_layout']=='box'){echo 'box-layout';}?> <?php if(class_exists('RevSliderFront')){ echo 'rs-active';} ?>">
	<div class="page-wrapper">
		<div class="header-container <?php echo strtolower($oxelar_opt['header_layout'])?>"> 
			<div class="<?php if(isset($oxelar_opt['sticky_header']) && $oxelar_opt['sticky_header']) {echo 'header-sticky';} ?> <?php if ( is_admin_bar_showing() ) {echo 'with-admin-bar';} ?>">
				 
				<div class="header-content">
					<?php
					if ( isset($oxelar_opt['header_layout']) && $oxelar_opt['header_layout']!="") {
						$jscomposer_templates_args = array(
							'orderby'          => 'title',
							'order'            => 'ASC',
							'post_type'        => 'templatera',
							'post_status'      => 'publish',
							'posts_per_page'      => 100,
						);
						$jscomposer_templates = get_posts( $jscomposer_templates_args );

						if(count($jscomposer_templates) > 0) {
							foreach($jscomposer_templates as $jscomposer_template){
								if($jscomposer_template->post_title == $oxelar_opt['header_layout']){
									echo do_shortcode($jscomposer_template->post_content);
								}
							}
						}
					} else {
						?>
                        <div class="col-xs-12 col-lg-12 logosec">
                        									<?php if( isset($oxelar_opt['logo_main']['url']) && $oxelar_opt['logo_main']['url']!=''){ ?>
                        										<div class="logo"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><img src="<?php echo esc_url($oxelar_opt['logo_main']['url']); ?>" alt="" /></a></div>
                        									<?php
                        									} else { ?>
                        										<h1 class="logo"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
                        										<?php
                        									} ?>
                        								</div>
                        <div class="col-xs-12 col-lg-12 headermenu">
                        	<div class="container">
                                <div class="nav-container">
                                                        										<div class="horizontal-menu visible-large">
                                                        											<?php wp_nav_menu( array( 'theme_location' => 'primary', 'container_class' => 'primary-menu-container', 'menu_class' => 'nav-menu' ) ); ?>
                                                        										</div>
                                                        									</div>
                        	</div>

                        								</div>
                        <div style="clear:both"></div>
						<div class="container-box">
							<div class="row">


							</div>
							<div class="visible-small box-right">
								<div class="mbmenu-toggler">
									<div class="mbmenu-icon"><i class="fa fa-bars"><span><?php echo esc_html($oxelar_opt['mobile_menu_label'], 'oxelar');?></i></span></div>
								</div>
							</div>
							<div class="visible-small mobile-menu-container default-menu">  
								<?php wp_nav_menu( array( 'theme_location' => 'mobilemenu', 'container_class' => 'mobile-menu-container visible-small', 'menu_class' => 'nav-menu' ) ); ?>
							</div>
						</div> 
						<?php
					} 
					?>
				</div> 
			</div> 
			<div class="clearfix"></div>
		</div>