<?php
/**
 * The template for displaying image attachments
 *
 * @link http://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage oxelar_Themes
 * @since Road Themes 1.0
 */

$oxelar_opt = get_option( 'oxelar_opt' );

get_header();

if(isset($oxelar_opt)){
	$bloglayout = 'nosidebar';
} else {
	$bloglayout = 'sidebar';
}
if(isset($oxelar_opt['blog_layout']) && $oxelar_opt['blog_layout']!=''){
	$bloglayout = $oxelar_opt['blog_layout'];
}
if(isset($_GET['layout']) && $_GET['layout']!=''){
	$bloglayout = $_GET['layout'];
}
$blogsidebar = 'right';
if(isset($oxelar_opt['sidebarblog_pos']) && $oxelar_opt['sidebarblog_pos']!=''){
	$blogsidebar = $oxelar_opt['sidebarblog_pos'];
}
if(isset($_GET['sidebar']) && $_GET['sidebar']!=''){
	$blogsidebar = $_GET['sidebar'];
}
switch($bloglayout) {
	case 'sidebar':
		$blogclass = 'blog-sidebar';
		$blogcolclass = 9;
		Oxelar::oxelar_post_thumbnail_size('oxelar-category-thumb');
		break;
	default:
		$blogclass = 'blog-nosidebar';
		$blogcolclass = 12;
		$blogsidebar = 'none';
		Oxelar::oxelar_post_thumbnail_size('oxelar-post-thumb');
}
?>
<div class="main-container page-wrapper"> 
	<div class="container-box"> 
		<div class="blog_header"> 
			<header class="entry-header"> 
				<h1 class="entry-title"><?php if(isset($oxelar_opt)) { echo esc_html($oxelar_opt['blog_header_text']); } else { esc_html_e('Blog', 'oxelar');}  ?></h1>
				
			</header>
			<?php Oxelar::oxelar_breadcrumb(); ?>

		</div>
		<div class="container"> 
			<div class="row">
				<?php if($blogsidebar=='left') : ?>
					<?php get_sidebar(); ?>
				<?php endif; ?>
				<div class="col-xs-12 <?php echo 'col-md-'.$blogcolclass; ?>">
				
					<div class="page-content blog-page single <?php echo esc_attr($blogclass); if($blogsidebar=='left') {echo ' left-sidebar'; } if($blogsidebar=='right') {echo ' right-sidebar'; } ?>">
						<?php while ( have_posts() ) : the_post(); ?>

							<article id="post-<?php the_ID(); ?>" <?php post_class( 'image-attachment' ); ?>>
								<div class="entry-content">
									<div class="post-thumbnail">
										<div class="entry-attachment">
											<div class="attachment">
												<?php
												/*
												 * Grab the IDs of all the image attachments in a gallery so we can get the URL of the next adjacent image in a gallery,
												 * or the first image (if we're looking at the last image in a gallery), or, in a gallery of one, just the link to that image file
												 */
												$attachments = array_values( get_children( array( 'post_parent' => $post->post_parent, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => 'ASC', 'orderby' => 'menu_order ID' ) ) );
												foreach ( $attachments as $k => $attachment ) :
													if ( $attachment->ID == $post->ID )
														break;
												endforeach;

												$k++;
												// If there is more than 1 attachment in a gallery
												if ( count( $attachments ) > 1 ) :
													if ( isset( $attachments[ $k ] ) ) :
														// get the URL of the next image attachment
														$next_attachment_url = get_attachment_link( $attachments[ $k ]->ID );
													else :
														// or get the URL of the first image attachment
														$next_attachment_url = get_attachment_link( $attachments[ 0 ]->ID );
													endif;
												else :
													// or, if there's only 1 image, get the URL of the image
													$next_attachment_url = wp_get_attachment_url();
												endif;
												?>
												<a href="<?php echo esc_url( $next_attachment_url ); ?>" title="<?php the_title_attribute(); ?>" rel="attachment"><?php
												/**
												 * Filter the image attachment size to use.
												 *
												 * @since Road Themes 1.0
												 *
												 * @param array $size {
												 *     @type int The attachment height in pixels.
												 *     @type int The attachment width in pixels.
												 * }
												 */
												$attachment_size = apply_filters( 'oxelar_attachment_size', array( 960, 960 ) );
												echo wp_get_attachment_image( $post->ID, $attachment_size );
												?></a>

												<?php if ( ! empty( $post->post_excerpt ) ) : ?>
												<div class="entry-caption">
													<?php the_excerpt(); ?>
												</div>
												<?php endif; ?>
											</div><!-- .attachment -->

										</div><!-- .entry-attachment -->
									</div>
									<div class="entry-description">
										<?php the_content(); ?>
										<?php wp_link_pages( array( 'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'oxelar' ), 'after' => '</div>' ) ); ?>
									</div><!-- .entry-description -->

								</div><!-- .entry-content -->
								<div class="postinfo-wrapper">
									<div class="post-date">
										<?php echo '<span class="day">'.get_the_date('d', $post->ID).'</span><span class="month"><span class="separator">/</span>'.get_the_date('M', $post->ID).'</span>' ;?>
									</div>
									<div class="post-info">
										<header class="entry-header">
											<h1 class="entry-title"><?php the_title(); ?></h1>
										</header><!-- .entry-header -->
										
										<footer class="entry-meta">
											<?php
												$metadata = wp_get_attachment_metadata();
												printf( esc_html__( '<span class="meta-prep meta-prep-entry-date">Published </span> <span class="entry-date"><time class="entry-date" datetime="%1$s">%2$s</time></span> at <a href="%3$s" title="Link to full-size image">%4$s &times; %5$s</a> in <a href="%6$s" title="Return to %7$s" rel="gallery">%8$s</a>.', 'oxelar' ),
													esc_attr( get_the_date( 'c' ) ),
													esc_html( get_the_date() ),
													esc_url( wp_get_attachment_url() ),
													$metadata['width'],
													$metadata['height'],
													esc_url( get_permalink( $post->post_parent ) ),
													esc_attr( strip_tags( get_the_title( $post->post_parent ) ) ),
													get_the_title( $post->post_parent )
												);
											?>
											<?php edit_post_link( esc_html__( 'Edit', 'oxelar' ), '<span class="edit-link">', '</span>' ); ?>
										</footer><!-- .entry-meta -->
									</div>
								</div>
								
							</article><!-- #post -->

							<?php comments_template(); ?>
							
						<?php endwhile; // end of the loop. ?>
					</div>
				</div>
				<?php if( $blogsidebar=='right') : ?>
					<?php get_sidebar(); ?>
				<?php endif; ?>
			</div>
		</div>
	</div>
</div>
<?php get_footer(); ?>