<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * For example, it puts together the home page when no home.php file exists.
 *
 * @link http://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage oxelar_Themes
 * @since Road Themes 1.0
 */
$oxelar_opt = get_option( 'oxelar_opt' );

get_header();

if(isset($oxelar_opt)){
	$bloglayout = 'sidebar';
} else {
	$bloglayout = 'nosidebar';
}
if(isset($oxelar_opt['blog_layout']) && $oxelar_opt['blog_layout']!=''){
	$bloglayout = $oxelar_opt['blog_layout'];
}
if(isset($_GET['layout']) && $_GET['layout']!=''){
	$bloglayout = $_GET['layout'];
}
$blogsidebar = 'right';
if(isset($oxelar_opt['sidebarblog_pos']) && $oxelar_opt['sidebarblog_pos']!=''){
	$blogsidebar = $oxelar_opt['sidebarblog_pos'];
}
if(isset($_GET['sidebar']) && $_GET['sidebar']!=''){
	$blogsidebar = $_GET['sidebar'];
}
switch($bloglayout) {
	case 'sidebar':
		$blogclass = 'blog-sidebar';
		$blogcolclass = 9;
		Oxelar::oxelar_post_thumbnail_size('oxelar-category-thumb');
		break;
	default:
		$blogclass = 'blog-nosidebar';
		$blogcolclass = 12;
		$blogsidebar = 'none';
		Oxelar::oxelar_post_thumbnail_size('oxelar-post-thumb');
}
?>
<div class="main-container"> 
	<div class="container-box">
		
		
		<div class="blog_header"> 
			<header class="entry-header"> 
				<h1 class="entry-title"><?php if(isset($oxelar_opt)) { echo esc_html($oxelar_opt['blog_header_text']); } else { esc_html_e('Blog', 'oxelar');}  ?></h1>
				
			</header>
			<?php Oxelar::oxelar_breadcrumb(); ?>

		</div>
		<div class="container"> 
			<div class="row">
				<?php if($blogsidebar=='left') : ?>
					<?php get_sidebar(); ?>
				<?php endif; ?>
				
				<div class="col-xs-12 <?php echo 'col-md-'.$blogcolclass; ?>">
				
					<div class="page-content blog-page <?php echo esc_attr($blogclass); if($blogsidebar=='left') {echo ' left-sidebar'; } if($blogsidebar=='right') {echo ' right-sidebar'; } ?>">
						<?php if ( have_posts() ) : ?>

							<?php /* Start the Loop */ ?>
							<?php while ( have_posts() ) : the_post(); ?>
								<?php get_template_part( 'content', get_post_format() ); ?>
							<?php endwhile; ?>

							<div class="pagination">
								<?php Oxelar::oxelar_pagination(); ?>
							</div>
							
						<?php else : ?>

							<article id="post-0" class="post no-results not-found">

							<?php if ( current_user_can( 'edit_posts' ) ) :
								// Show a different message to a logged-in user who can add posts.
							?>
								<header class="entry-header">
									<h1 class="entry-title"><?php esc_html_e( 'No posts to display', 'oxelar' ); ?></h1>
								</header>

								<div class="entry-content">
									<p><?php printf( esc_html__( 'Ready to publish your first post? <a href="%s">Get started here</a>.', 'oxelar' ), admin_url( 'post-new.php' ) ); ?></p>
								</div><!-- .entry-content -->

							<?php else :
								// Show the default message to everyone else.
							?>
								<header class="entry-header">
									<h1 class="entry-title"><?php esc_html_e( 'Nothing Found', 'oxelar' ); ?></h1>
								</header>

								<div class="entry-content">
									<p><?php esc_html_e( 'Apologies, but no results were found. Perhaps searching will help find a related post.', 'oxelar' ); ?></p>
									<?php get_search_form(); ?>
								</div><!-- .entry-content -->
							<?php endif; // end current_user_can() check ?>

							</article><!-- #post-0 -->

						<?php endif; // end have_posts() check ?>
					</div>
					
				</div>
				<?php if( $blogsidebar=='right') : ?>
					<?php get_sidebar(); ?>
				<?php endif; ?>
			</div>
		</div>
	</div>
</div>
<?php get_footer(); ?>