<?php
/**
 * The template for displaying Search Results pages
 *
 * @package WordPress
 * @subpackage oxelar_Themes
 * @since Road Themes 1.0
 */

$oxelar_opt = get_option( 'oxelar_opt' );

get_header();

if(isset($oxelar_opt)){
	$bloglayout = 'nosidebar';
} else {
	$bloglayout = 'sidebar';
}
if(isset($oxelar_opt['blog_layout']) && $oxelar_opt['blog_layout']!=''){
	$bloglayout = $oxelar_opt['blog_layout'];
}
if(isset($_GET['layout']) && $_GET['layout']!=''){
	$bloglayout = $_GET['layout'];
}
$blogsidebar = 'right';
if(isset($oxelar_opt['sidebarblog_pos']) && $oxelar_opt['sidebarblog_pos']!=''){
	$blogsidebar = $oxelar_opt['sidebarblog_pos'];
}
if(isset($_GET['sidebar']) && $_GET['sidebar']!=''){
	$blogsidebar = $_GET['sidebar'];
}
switch($bloglayout) {
	case 'sidebar':
		$blogclass = 'blog-sidebar';
		$blogcolclass = 9;
		Oxelar::oxelar_post_thumbnail_size('oxelar-category-thumb');
		break;
	default:
		$blogclass = 'blog-nosidebar';
		$blogcolclass = 12;
		$blogsidebar = 'none';
		Oxelar::oxelar_post_thumbnail_size('oxelar-post-thumb');
}
?>
<div class="main-container page-wrapper">
	<?php Oxelar::oxelar_breadcrumb(); ?>
	<div class="container"> 
		<header class="entry-header">
			<div class="container">
				<h1 class="entry-title"><?php if(isset($oxelar_opt)) { echo esc_html($oxelar_opt['blog_header_text']); } else { esc_html_e('Blog', 'oxelar');}  ?></h1>
			</div>
		</header>
		<div class="row">
			<?php if($blogsidebar=='left') : ?>
				<?php get_sidebar(); ?>
			<?php endif; ?>
			
			<div class="col-xs-12 <?php echo 'col-md-'.$blogcolclass; ?>">
			
				<div class="page-content blog-page <?php echo esc_attr($blogclass); if($blogsidebar=='left') {echo ' left-sidebar'; } if($blogsidebar=='right') {echo ' right-sidebar'; } ?>">
					<?php if ( have_posts() ) : ?>
						
						<header class="archive-header">
							<h1 class="archive-title"><?php printf( esc_html__( 'Search Results for: %s', 'oxelar' ), '<span>' . get_search_query() . '</span>' ); ?></h1>
						</header><!-- .archive-header -->

						<?php /* Start the Loop */ ?>
						<?php while ( have_posts() ) : the_post(); ?>
							<?php get_template_part( 'content', get_post_format() ); ?>
						<?php endwhile; ?>

						<div class="pagination">
							<?php Oxelar::oxelar_pagination(); ?>
						</div>

					<?php else : ?>

						<article id="post-0" class="post no-results not-found">
							<header class="entry-header">
								<h1 class="entry-title"><?php esc_html_e( 'Nothing Found', 'oxelar' ); ?></h1>
							</header>

							<div class="entry-content">
								<p><?php esc_html_e( 'Sorry, but nothing matched your search criteria. Please try again with some different keywords.', 'oxelar' ); ?></p>
								<?php get_search_form(); ?>
							</div><!-- .entry-content -->
						</article><!-- #post-0 -->

					<?php endif; ?>
				</div>
			</div>
			<?php if( $blogsidebar=='right') : ?>
				<?php get_sidebar(); ?>
			<?php endif; ?>
		</div>
		
	</div>
</div>
<?php get_footer(); ?>